/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class HTMLDocumentLoader {
    protected static HTMLEditorKit kit = new HTMLEditorKit();
    protected static HTMLEditorKit.Parser parser;

    HTMLDocumentLoader() {
    }

    public HTMLDocument loadDocument(HTMLDocument doc, URL url, String charSet) throws IOException {
        doc.putProperty("stream", url);
        InputStream in = null;
        boolean ignoreCharSet = false;
        while (true) {
            try {
                doc.remove(0, doc.getLength());
                URLConnection urlc = url.openConnection();
                in = urlc.getInputStream();
                InputStreamReader reader = charSet == null ? new InputStreamReader(in) : new InputStreamReader(in, charSet);
                HTMLEditorKit.Parser parser = this.getParser();
                HTMLEditorKit.ParserCallback htmlReader = this.getParserCallback(doc);
                parser.parse(reader, htmlReader, ignoreCharSet);
                htmlReader.flush();
            }
            catch (BadLocationException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (ChangedCharSetException e) {
                charSet = this.getNewCharSet(e);
                ignoreCharSet = true;
                in.close();
                continue;
            }
            break;
        }
        return doc;
    }

    public HTMLDocument loadDocument(URL url, String charSet) throws IOException {
        return this.loadDocument((HTMLDocument)kit.createDefaultDocument(), url, charSet);
    }

    public HTMLDocument loadDocument(URL url) throws IOException {
        return this.loadDocument(url, null);
    }

    public synchronized HTMLEditorKit.Parser getParser() {
        if (parser == null) {
            try {
                Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                parser = (HTMLEditorKit.Parser)c.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return parser;
    }

    public synchronized HTMLEditorKit.ParserCallback getParserCallback(HTMLDocument doc) {
        return doc.getReader(0);
    }

    protected String getNewCharSet(ChangedCharSetException e) {
        String spec = e.getCharSetSpec();
        if (e.keyEqualsCharSet()) {
            return spec;
        }
        int index = spec.indexOf(";");
        if (index != -1) {
            spec = spec.substring(index + 1);
        }
        spec = spec.toLowerCase();
        StringTokenizer st = new StringTokenizer(spec, " \t=", true);
        boolean foundCharSet = false;
        boolean foundEquals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            if (!foundCharSet && !foundEquals && token.equals("charset")) {
                foundCharSet = true;
                continue;
            }
            if (!foundEquals && token.equals("=")) {
                foundEquals = true;
                continue;
            }
            if (foundEquals && foundCharSet) {
                return token;
            }
            foundCharSet = false;
            foundEquals = false;
        }
        return "8859_1";
    }
}

