/*
 * Decompiled with CFR 0.152.
 */
package Lmeasure.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class Output
extends JPanel
implements ActionListener,
ItemListener {
    JButton out_But;
    JCheckBox global;
    JCheckBox rawdata;
    JCheckBox swc;
    JCheckBox wrl;
    JCheckBox dxf;
    JCheckBox tree_checkbox;
    JCheckBox tree_analysis;
    JTextField tf1;
    JTextField tf2;
    ButtonGroup treeGroup;
    JRadioButton treeAnalRadio;
    JRadioButton treeGenRadio;
    JComponent comp = null;
    JPanel LeftPanel;
    JPanel TopPanel;
    JPanel textPanel;
    JPanel treePanel;
    JPanel mainPanel;
    Preferences _prefs;

    public Output() {
    }

    public Output(int dummy4) {
        try {
            this.out_But = new JButton("Output File>");
            this.LeftPanel = new JPanel();
            this.TopPanel = new JPanel();
            this.textPanel = new JPanel();
            this.treePanel = new JPanel();
            this.treeGroup = new ButtonGroup();
            this.global = new JCheckBox("Global");
            this.rawdata = new JCheckBox("Raw Data");
            this.swc = new JCheckBox("SWC Conversion");
            this.wrl = new JCheckBox("WRL Conversion");
            this.dxf = new JCheckBox("DXF Conversion");
            this.tree_analysis = new JCheckBox("Subtrees Group");
            this.treeAnalRadio = new JRadioButton("Analyse Subtrees");
            this.treeGenRadio = new JRadioButton("Generate Subtrees", true);
            this.tf1 = new JTextField();
            this.tf2 = new JTextField();
            this._prefs = Preferences.userNodeForPackage(Output.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JPanel getOutputPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.mainPanel.setLayout(new BorderLayout(10, 0));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        this.LeftPanel.setLayout(new GridLayout(0, 1));
        this.LeftPanel.add(this.global);
        this.LeftPanel.add(this.rawdata);
        this.LeftPanel.add(this.swc);
        this.LeftPanel.add(this.wrl);
        this.LeftPanel.add(this.dxf);
        this.LeftPanel.add(this.tree_analysis);
        this.treePanel.setLayout(new GridLayout(1, 2));
        this.treeGroup.add(this.treeAnalRadio);
        this.treeGroup.add(this.treeGenRadio);
        this.treePanel.add(this.treeAnalRadio);
        this.treePanel.add(this.treeGenRadio);
        this.treePanel.setBorder(BorderFactory.createTitledBorder(loweredetched, "Subtrees Group"));
        this.treeAnalRadio.setEnabled(false);
        this.treeGenRadio.setEnabled(false);
        this.treePanel.setEnabled(false);
        this.LeftPanel.add(this.treePanel);
        this.mainPanel.add((Component)this.LeftPanel, "West");
        this.out_But = new JButton("Output File>");
        this.tf1.setPreferredSize(new Dimension(250, 20));
        this.TopPanel.add(this.out_But);
        this.TopPanel.add(this.tf1);
        this.mainPanel.add((Component)this.TopPanel, "North");
        this.mainPanel.add((Component)this.textPanel, "Center");
        this.out_But.addActionListener(this);
        this.tree_analysis.addItemListener(this);
        this.global.addItemListener(this);
        this.rawdata.addItemListener(this);
        this.swc.addItemListener(this);
        this.wrl.addItemListener(this);
        this.dxf.addItemListener(this);
        return this.mainPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File input = null;
        if (ae.getSource().equals(this.out_But)) {
            block10: {
                try {
                    JFileChooser fc2 = new JFileChooser();
                    String dp = this._prefs.get("output_path", ".");
                    fc2.setCurrentDirectory(new File(dp));
                    fc2.setFileSelectionMode(0);
                    int returnVal = fc2.showSaveDialog(this.getRootPane());
                    if (returnVal != 0) break block10;
                    try {
                        input = fc2.getSelectedFile();
                        if (input == null) {
                            return;
                        }
                        this._prefs.put("output_path", input.getPath());
                        String[] message = new String[]{"This file already exists,", "Do you wish to overwrite?"};
                        if (input.exists()) {
                            int res = JOptionPane.showConfirmDialog(this, message, "Save warning", 2, 3);
                            if (res == 0) {
                                fc2.approveSelection();
                                this.tf1.setText(input.getAbsolutePath());
                            } else if (res == 2) {
                                return;
                            }
                            break block10;
                        }
                        this.tf1.setText(input.getAbsolutePath());
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                }
                catch (Exception e) {
                    this.tf1.setText(e.toString());
                }
            }
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        try {
            if (this.tree_analysis.isSelected()) {
                if (!this.rawdata.isSelected() && !this.swc.isSelected()) {
                    this.treeAnalRadio.setEnabled(true);
                }
                this.treeGenRadio.setEnabled(true);
                this.treePanel.setEnabled(true);
            } else {
                this.treeAnalRadio.setSelected(false);
                this.treeAnalRadio.setEnabled(false);
                this.treeGenRadio.setSelected(false);
                this.treeGenRadio.setEnabled(false);
                this.treePanel.setEnabled(false);
            }
            if (this.rawdata.isSelected() && this.tree_analysis.isSelected()) {
                this.tree_analysis.setSelected(false);
                this.tree_analysis.setEnabled(false);
            }
            if (this.swc.isSelected() && this.tree_analysis.isSelected()) {
                this.tree_analysis.setSelected(false);
                this.tree_analysis.setEnabled(false);
            }
            if (this.wrl.isSelected() && this.tree_analysis.isSelected()) {
                this.tree_analysis.setSelected(false);
                this.tree_analysis.setEnabled(false);
            }
            if (this.dxf.isSelected() && this.tree_analysis.isSelected()) {
                this.tree_analysis.setSelected(false);
                this.tree_analysis.setEnabled(false);
            }
            if (!this.rawdata.isSelected() && !this.swc.isSelected()) {
                this.tree_analysis.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

