"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NoIngressCommonWebPortsAspect = exports.NoPublicIngressCommonWebPortsAspect = exports.NoIngressCommonRelationalDBPortsAspect = exports.NoPublicIngressCommonRelationalDBPortsAspect = exports.NoIngressCommonManagementPortsAspect = exports.NoPublicIngressCommonManagementPortsAspect = exports.AWSRestrictedCommonPortsAspect = exports.CISAwsFoundationBenchmark4Dot2Aspect = exports.NoPublicIngressRDPAspect = exports.CISAwsFoundationBenchmark4Dot1Aspect = exports.NoPublicIngressSSHAspect = exports.NoPublicIngressAspect = exports.NoPublicIngressAspectBase = exports.SecurityGroupAspectBase = exports.checkRules = exports.annotate = exports.anyInRange = exports.AnnotationType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const cdk = require("@aws-cdk/core");
/**
 * The supported annotation types. Only error will stop deployment of restricted resources.
 */
var AnnotationType;
(function (AnnotationType) {
    AnnotationType["WARNING"] = "warning";
    AnnotationType["ERROR"] = "error";
    AnnotationType["INFO"] = "info";
})(AnnotationType = exports.AnnotationType || (exports.AnnotationType = {}));
;
/**
 * @function anyInRange
 * Function to check if a number is in a range.
 *
 * Useful for determining if a port number in a security group is in part of a range since rules take a to and from port.
 *
 * @param num The number to check.
 * @param from The starting number of the range.
 * @param to The ending number of the range.
 */
function anyInRange(num, from, to) {
    for (const n of num) {
        if (n >= from && n <= to) {
            return true;
        }
    }
    return false;
}
exports.anyInRange = anyInRange;
/**
 * @function annotate
 * Function to annotate a construct node based on a defined annotation type.
 *
 * @param {cdk.IConstruct} node The construct node to annotate.
 * @param {string} annotationText The annotation text to use for the annotation.
 * @param {AnnotationType} annotationType The annotation type to use for the annotation.
 */
function annotate(node, annotationText, annotationType) {
    annotationText = annotationText || 'A security group rule was blocked by an aspect applied to this stack.';
    annotationType = annotationType || AnnotationType.ERROR;
    switch (annotationType) {
        case 'error':
            cdk.Annotations.of(node).addError(annotationText);
            break;
        case 'warning':
            cdk.Annotations.of(node).addWarning(annotationText);
            break;
        case 'info':
            cdk.Annotations.of(node).addInfo(annotationText);
            break;
    }
}
exports.annotate = annotate;
/**
 * @function checkRules
 *
 * @param {IRuleCheckArgs} args The arguments for the checkRules function.
 *
 * Function to check a node for security group rules and determine if they breaks the rules of a given aspect.
 */
function checkRules(args) {
    if (args.node instanceof ec2.CfnSecurityGroup) {
        checkInlineRules(cdk.Stack.of(args.node).resolve(args.node.securityGroupIngress));
    }
    else if (args.node instanceof ec2.CfnSecurityGroupIngress) {
        checkRule(args.node);
    }
    function checkInlineRules(rules) {
        if (rules) {
            for (const rule of rules.values()) {
                checkRule(rule);
            }
        }
    }
    function checkRule(rule) {
        if (!cdk.Tokenization.isResolvable(rule)) {
            let matchingSource = false;
            let matchingPort = false;
            let shouldAnnotate = false;
            if (args.ports === undefined) {
                matchingPort = true;
            }
            else if (args.ports && rule.fromPort && rule.toPort && anyInRange(args.ports, rule.fromPort, rule.toPort)) {
                matchingPort = true;
            }
            if (rule.cidrIp) {
                if (args.anySource) {
                    matchingSource = true;
                }
                if (args.anySource == false && args.restrictedCidrs !== undefined && args.restrictedCidrs.includes(rule.cidrIp)) {
                    matchingSource = true;
                }
                if (matchingSource && matchingPort) {
                    shouldAnnotate = true;
                }
            }
            if (rule.sourceSecurityGroupId) {
                if (args.anySource) {
                    matchingSource = true;
                }
                if (args.anySource == false && args.restrictedSGs !== undefined && args.restrictedSGs.includes(rule.sourceSecurityGroupId)) {
                    matchingSource = true;
                }
                if (matchingSource && matchingPort) {
                    shouldAnnotate = true;
                }
            }
            if (shouldAnnotate) {
                annotate(args.node, args.annotationText, args.annotationType);
            }
        }
    }
}
exports.checkRules = checkRules;
/**
 * The base class for all security group aspects in the library.
 *
 * By default this will not restrict anything.
 */
class SecurityGroupAspectBase {
    constructor(props) {
        var _q, _r, _s;
        this.annotationType = (_q = props === null || props === void 0 ? void 0 : props.annotationType) !== null && _q !== void 0 ? _q : AnnotationType.ERROR;
        this.annotationText = (_r = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _r !== void 0 ? _r : 'A security group rule was blocked by an aspect applied to this stack.';
        this.ports = props === null || props === void 0 ? void 0 : props.ports;
        this.restrictedCidrs = props === null || props === void 0 ? void 0 : props.restrictedCidrs;
        this.restrictedSGs = props === null || props === void 0 ? void 0 : props.restrictedSGs;
        this.anySource = (_s = props === null || props === void 0 ? void 0 : props.anySource) !== null && _s !== void 0 ? _s : false;
    }
    visit(node) {
        checkRules({
            node,
            annotationText: this.annotationText,
            annotationType: this.annotationType,
            ports: this.ports,
            restrictedCidrs: this.restrictedCidrs,
            restrictedSGs: this.restrictedSGs,
            anySource: this.anySource,
        });
    }
}
exports.SecurityGroupAspectBase = SecurityGroupAspectBase;
_a = JSII_RTTI_SYMBOL_1;
SecurityGroupAspectBase[_a] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.SecurityGroupAspectBase", version: "1.0.98" };
/**
 * The base aspect to determine if a security group allows inbound traffic from the public internet to any port.
 *
 * This inherits everything from the base SecurityGroupAspectBase class and sets a default set of CIDRS that match allowing all IPs on AWS.
 */
class NoPublicIngressAspectBase extends SecurityGroupAspectBase {
    constructor(props) {
        super(props);
        this.restrictedCidrs = ['0.0.0.0/0', '::/0'];
    }
}
exports.NoPublicIngressAspectBase = NoPublicIngressAspectBase;
_b = JSII_RTTI_SYMBOL_1;
NoPublicIngressAspectBase[_b] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressAspectBase", version: "1.0.98" };
/**
 * The same as the base NoPublicIngressAspectBase but with a more descriptive annotation.
 *
 * Blocks the ANY port from the public internet.
 */
class NoPublicIngressAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressAspect: A security group rule allows public access to a restricted port: All ports restricted).';
    }
}
exports.NoPublicIngressAspect = NoPublicIngressAspect;
_c = JSII_RTTI_SYMBOL_1;
NoPublicIngressAspect[_c] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressAspect", version: "1.0.98" };
/**
 * Aspect to determine if a security group allows inbound traffic from the public internet to the SSH port.
 */
class NoPublicIngressSSHAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressSSHAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 22 (SSH)';
        this.ports = [22];
    }
}
exports.NoPublicIngressSSHAspect = NoPublicIngressSSHAspect;
_d = JSII_RTTI_SYMBOL_1;
NoPublicIngressSSHAspect[_d] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressSSHAspect", version: "1.0.98" };
/**
 * CIS AWS Foundations Benchmark 4.1
 *
 * CIS recommends that no security group allow unrestricted ingress access to port 22. Removing unfettered connectivity to remote console services, such as SSH, reduces a server's exposure to risk.
 *
 * This aspect uses the NoPublicIngressSSHAspect with an alternate annotation text.
 */
class CISAwsFoundationBenchmark4Dot1Aspect extends NoPublicIngressSSHAspect {
    constructor(props) {
        super(props);
        this.annotationText = 'CIS AWS Foundations Benchmark 4.1: Ensure no security groups allow ingress from 0.0.0.0/0 to port 22';
    }
}
exports.CISAwsFoundationBenchmark4Dot1Aspect = CISAwsFoundationBenchmark4Dot1Aspect;
_e = JSII_RTTI_SYMBOL_1;
CISAwsFoundationBenchmark4Dot1Aspect[_e] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.CISAwsFoundationBenchmark4Dot1Aspect", version: "1.0.98" };
/**
 * Aspect to determine if a security group allows inbound traffic from the public internet to the RDP port.
 */
class NoPublicIngressRDPAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressRDPAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 3389 (RDP)';
        this.ports = [3389];
    }
}
exports.NoPublicIngressRDPAspect = NoPublicIngressRDPAspect;
_f = JSII_RTTI_SYMBOL_1;
NoPublicIngressRDPAspect[_f] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressRDPAspect", version: "1.0.98" };
/**
 * CIS AWS Foundations Benchmark 4.2
 *
 * CIS recommends that no security group allow unrestricted ingress access to port 3389. Removing unfettered connectivity to remote console services, such as RDP, reduces a server's exposure to risk.
 *
 * This aspect uses the NoPublicIngressRDPAspect with an alternate annotation text.
 */
class CISAwsFoundationBenchmark4Dot2Aspect extends NoPublicIngressRDPAspect {
    constructor(props) {
        super(props);
        this.annotationText = 'CIS AWS Foundations Benchmark 4.2: Ensure no security groups allow ingress from 0.0.0.0/0 to port 3389';
    }
}
exports.CISAwsFoundationBenchmark4Dot2Aspect = CISAwsFoundationBenchmark4Dot2Aspect;
_g = JSII_RTTI_SYMBOL_1;
CISAwsFoundationBenchmark4Dot2Aspect[_g] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.CISAwsFoundationBenchmark4Dot2Aspect", version: "1.0.98" };
/**
 * Restricted common ports based on AWS Config rule https://docs.aws.amazon.com/config/latest/developerguide/restricted-common-ports.html
 */
class AWSRestrictedCommonPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            20,
            21,
            3389,
            3306,
            4333,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'AWSRestrictedCommonPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 20, 21, 3389, 3306, 4333';
    }
}
exports.AWSRestrictedCommonPortsAspect = AWSRestrictedCommonPortsAspect;
_h = JSII_RTTI_SYMBOL_1;
AWSRestrictedCommonPortsAspect[_h] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.AWSRestrictedCommonPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict public access to common management ports.
 *
 * 22 - SSH
 * 3389 - RDP
 * 5985 - WinRM
 * 5986 - WinRM HTTPS
 */
class NoPublicIngressCommonManagementPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            22,
            3389,
            5985,
            5986,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressCommonManagementPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 22, 3389, 5985, 5986';
    }
}
exports.NoPublicIngressCommonManagementPortsAspect = NoPublicIngressCommonManagementPortsAspect;
_j = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonManagementPortsAspect[_j] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonManagementPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict any access to common management ports.
 *
 * 22 - SSH
 * 3389 - RDP
 * 5985 - WinRM
 * 5986 - WinRM HTTPS
 */
class NoIngressCommonManagementPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            22,
            3389,
            5985,
            5986,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoIngressCommonManagementPortsAspect: A security group rule allows access to a restricted port: 22, 3389, 5985, 5986';
        this.anySource = true;
    }
}
exports.NoIngressCommonManagementPortsAspect = NoIngressCommonManagementPortsAspect;
_k = JSII_RTTI_SYMBOL_1;
NoIngressCommonManagementPortsAspect[_k] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonManagementPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict public access to common relational DB ports.
 *
 * 3306 - MySQL
 * 5432 - PostgreSQL
 * 1521 - Oracle
 * 1433 - SQL Server
 */
class NoPublicIngressCommonRelationalDBPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            3306,
            5432,
            1521,
            1433,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressCommonRelationalDBPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 3306, 5432, 1521, 1433';
    }
}
exports.NoPublicIngressCommonRelationalDBPortsAspect = NoPublicIngressCommonRelationalDBPortsAspect;
_l = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonRelationalDBPortsAspect[_l] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonRelationalDBPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict any access to common relational DB ports.
 *
 * 3306 - MySQL
 * 5432 - PostgreSQL
 * 1521 - Oracle
 * 1433 - SQL Server
 */
class NoIngressCommonRelationalDBPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            3306,
            5432,
            1521,
            1433,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoIngressCommonRelationalDBPortsAspect: A security group rule allows access to a restricted port: 3306, 5432, 1521, 1433';
        this.anySource = true;
    }
}
exports.NoIngressCommonRelationalDBPortsAspect = NoIngressCommonRelationalDBPortsAspect;
_m = JSII_RTTI_SYMBOL_1;
NoIngressCommonRelationalDBPortsAspect[_m] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonRelationalDBPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict public access to common web ports.
 *
 * 80 - HTTP
 * 443 - HTTPS
 * 8080 - HTTP
 * 8443 - HTTPS
 */
class NoPublicIngressCommonWebPortsAspect extends NoPublicIngressAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            80,
            443,
            8080,
            8443,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoPublicIngressCommonWebPortsAspect: A security group rule allows access to a restricted port from public IPs (0.0.0.0/0): 80, 443, 8080, 8443';
    }
}
exports.NoPublicIngressCommonWebPortsAspect = NoPublicIngressCommonWebPortsAspect;
_o = JSII_RTTI_SYMBOL_1;
NoPublicIngressCommonWebPortsAspect[_o] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoPublicIngressCommonWebPortsAspect", version: "1.0.98" };
/**
 * Aspect to restrict any access to common web ports.
 *
 * 80 - HTTP
 * 443 - HTTPS
 * 8080 - HTTP
 * 8443 - HTTPS
 */
class NoIngressCommonWebPortsAspect extends SecurityGroupAspectBase {
    constructor(props) {
        var _q;
        super(props);
        this.ports = [
            80,
            443,
            8080,
            8443,
        ];
        this.annotationText = (_q = props === null || props === void 0 ? void 0 : props.annotationText) !== null && _q !== void 0 ? _q : 'NoIngressCommonWebPortsAspect: A security group rule allows access to a restricted port: 80, 443, 8080, 8443';
        this.anySource = true;
    }
}
exports.NoIngressCommonWebPortsAspect = NoIngressCommonWebPortsAspect;
_p = JSII_RTTI_SYMBOL_1;
NoIngressCommonWebPortsAspect[_p] = { fqn: "@renovosolutions/cdk-aspects-library-security-group.NoIngressCommonWebPortsAspect", version: "1.0.98" };
//# sourceMappingURL=data:application/json;base64,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