from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class CameraSetTiltRequest:
    """
    ROS message: drone_srv_msgs/CameraSetTiltRequest
    Generated by hakoniwa-ros2pdu.
    """

    drone_name: str
    tilt_angle_deg: float

    def __init__(self):
        self.drone_name = ""
        self.tilt_angle_deg = 0.0

    def __str__(self):
        return f"CameraSetTiltRequest(" + ", ".join([
            f"drone_name={self.drone_name}"
            f"tilt_angle_deg={self.tilt_angle_deg}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'drone_name'
        field_val = self.drone_name
        if isinstance(field_val, bytearray):
            d['drone_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['drone_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['drone_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['drone_name'] = field_val
        # handle field 'tilt_angle_deg'
        field_val = self.tilt_angle_deg
        if isinstance(field_val, bytearray):
            d['tilt_angle_deg'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['tilt_angle_deg'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['tilt_angle_deg'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['tilt_angle_deg'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'drone_name'
        if 'drone_name' in d:
            field_type = cls.__annotations__.get('drone_name')
            value = d['drone_name']
            
            if field_type is bytearray:
                obj.drone_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.drone_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.drone_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.drone_name = field_type.from_dict(value)
            else:
                obj.drone_name = value
        # handle field 'tilt_angle_deg'
        if 'tilt_angle_deg' in d:
            field_type = cls.__annotations__.get('tilt_angle_deg')
            value = d['tilt_angle_deg']
            
            if field_type is bytearray:
                obj.tilt_angle_deg = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.tilt_angle_deg = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.tilt_angle_deg = value
            elif hasattr(field_type, 'from_dict'):
                obj.tilt_angle_deg = field_type.from_dict(value)
            else:
                obj.tilt_angle_deg = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
