from typing import List

# dependencies for the generated Python class
from ..ev3_msgs.pdu_pytype_Ev3PduActuatorHeader import Ev3PduActuatorHeader
from ..ev3_msgs.pdu_pytype_Ev3PduMotor import Ev3PduMotor


# class definition for the ROS message
class Ev3PduActuator:
    """
    ROS message: ev3_msgs/Ev3PduActuator
    Generated by hakoniwa-ros2pdu.
    """

    head: Ev3PduActuatorHeader
    leds: List[int]
    motors: List[Ev3PduMotor]
    gyro_reset: int

    def __init__(self):
        self.head = Ev3PduActuatorHeader()
        self.leds = []
        self.motors = []
        self.gyro_reset = 0

    def __str__(self):
        return f"Ev3PduActuator(" + ", ".join([
            f"head={self.head}"
            f"leds={self.leds}"
            f"motors={self.motors}"
            f"gyro_reset={self.gyro_reset}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'head'
        field_val = self.head
        if isinstance(field_val, bytearray):
            d['head'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['head'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['head'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['head'] = field_val
        # handle field 'leds'
        field_val = self.leds
        if isinstance(field_val, bytearray):
            d['leds'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['leds'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['leds'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['leds'] = field_val
        # handle field 'motors'
        field_val = self.motors
        if isinstance(field_val, bytearray):
            d['motors'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['motors'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['motors'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['motors'] = field_val
        # handle field 'gyro_reset'
        field_val = self.gyro_reset
        if isinstance(field_val, bytearray):
            d['gyro_reset'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['gyro_reset'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['gyro_reset'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['gyro_reset'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'head'
        if 'head' in d:
            field_type = cls.__annotations__.get('head')
            value = d['head']
            
            if field_type is bytearray:
                obj.head = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.head = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.head = value
            elif hasattr(field_type, 'from_dict'):
                obj.head = field_type.from_dict(value)
            else:
                obj.head = value
        # handle field 'leds'
        if 'leds' in d:
            field_type = cls.__annotations__.get('leds')
            value = d['leds']
            
            if field_type is bytearray:
                obj.leds = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.leds = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.leds = value
            elif hasattr(field_type, 'from_dict'):
                obj.leds = field_type.from_dict(value)
            else:
                obj.leds = value
        # handle field 'motors'
        if 'motors' in d:
            field_type = cls.__annotations__.get('motors')
            value = d['motors']
            
            if field_type is bytearray:
                obj.motors = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.motors = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.motors = value
            elif hasattr(field_type, 'from_dict'):
                obj.motors = field_type.from_dict(value)
            else:
                obj.motors = value
        # handle field 'gyro_reset'
        if 'gyro_reset' in d:
            field_type = cls.__annotations__.get('gyro_reset')
            value = d['gyro_reset']
            
            if field_type is bytearray:
                obj.gyro_reset = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.gyro_reset = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.gyro_reset = value
            elif hasattr(field_type, 'from_dict'):
                obj.gyro_reset = field_type.from_dict(value)
            else:
                obj.gyro_reset = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
