from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Transform import Transform
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class TransformStamped:
    """
    ROS message: geometry_msgs/TransformStamped
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    child_frame_id: str
    transform: Transform

    def __init__(self):
        self.header = Header()
        self.child_frame_id = ""
        self.transform = Transform()

    def __str__(self):
        return f"TransformStamped(" + ", ".join([
            f"header={self.header}"
            f"child_frame_id={self.child_frame_id}"
            f"transform={self.transform}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'child_frame_id'
        field_val = self.child_frame_id
        if isinstance(field_val, bytearray):
            d['child_frame_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['child_frame_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['child_frame_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['child_frame_id'] = field_val
        # handle field 'transform'
        field_val = self.transform
        if isinstance(field_val, bytearray):
            d['transform'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['transform'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['transform'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['transform'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'child_frame_id'
        if 'child_frame_id' in d:
            field_type = cls.__annotations__.get('child_frame_id')
            value = d['child_frame_id']
            
            if field_type is bytearray:
                obj.child_frame_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.child_frame_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.child_frame_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.child_frame_id = field_type.from_dict(value)
            else:
                obj.child_frame_id = value
        # handle field 'transform'
        if 'transform' in d:
            field_type = cls.__annotations__.get('transform')
            value = d['transform']
            
            if field_type is bytearray:
                obj.transform = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.transform = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.transform = value
            elif hasattr(field_type, 'from_dict'):
                obj.transform = field_type.from_dict(value)
            else:
                obj.transform = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
