from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Point import Point
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Collision:
    """
    ROS message: hako_msgs/Collision
    Generated by hakoniwa-ros2pdu.
    """

    collision: bool
    contact_num: int
    relative_velocity: Vector3
    contact_position: List[Point]
    restitution_coefficient: float

    def __init__(self):
        self.collision = False
        self.contact_num = 0
        self.relative_velocity = Vector3()
        self.contact_position = []
        self.restitution_coefficient = 0.0

    def __str__(self):
        return f"Collision(" + ", ".join([
            f"collision={self.collision}"
            f"contact_num={self.contact_num}"
            f"relative_velocity={self.relative_velocity}"
            f"contact_position={self.contact_position}"
            f"restitution_coefficient={self.restitution_coefficient}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'collision'
        field_val = self.collision
        if isinstance(field_val, bytearray):
            d['collision'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['collision'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['collision'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['collision'] = field_val
        # handle field 'contact_num'
        field_val = self.contact_num
        if isinstance(field_val, bytearray):
            d['contact_num'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['contact_num'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['contact_num'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['contact_num'] = field_val
        # handle field 'relative_velocity'
        field_val = self.relative_velocity
        if isinstance(field_val, bytearray):
            d['relative_velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['relative_velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['relative_velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['relative_velocity'] = field_val
        # handle field 'contact_position'
        field_val = self.contact_position
        if isinstance(field_val, bytearray):
            d['contact_position'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['contact_position'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['contact_position'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['contact_position'] = field_val
        # handle field 'restitution_coefficient'
        field_val = self.restitution_coefficient
        if isinstance(field_val, bytearray):
            d['restitution_coefficient'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['restitution_coefficient'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['restitution_coefficient'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['restitution_coefficient'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'collision'
        if 'collision' in d:
            field_type = cls.__annotations__.get('collision')
            value = d['collision']
            
            if field_type is bytearray:
                obj.collision = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.collision = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.collision = value
            elif hasattr(field_type, 'from_dict'):
                obj.collision = field_type.from_dict(value)
            else:
                obj.collision = value
        # handle field 'contact_num'
        if 'contact_num' in d:
            field_type = cls.__annotations__.get('contact_num')
            value = d['contact_num']
            
            if field_type is bytearray:
                obj.contact_num = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.contact_num = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.contact_num = value
            elif hasattr(field_type, 'from_dict'):
                obj.contact_num = field_type.from_dict(value)
            else:
                obj.contact_num = value
        # handle field 'relative_velocity'
        if 'relative_velocity' in d:
            field_type = cls.__annotations__.get('relative_velocity')
            value = d['relative_velocity']
            
            if field_type is bytearray:
                obj.relative_velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.relative_velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.relative_velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.relative_velocity = field_type.from_dict(value)
            else:
                obj.relative_velocity = value
        # handle field 'contact_position'
        if 'contact_position' in d:
            field_type = cls.__annotations__.get('contact_position')
            value = d['contact_position']
            
            if field_type is bytearray:
                obj.contact_position = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.contact_position = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.contact_position = value
            elif hasattr(field_type, 'from_dict'):
                obj.contact_position = field_type.from_dict(value)
            else:
                obj.contact_position = value
        # handle field 'restitution_coefficient'
        if 'restitution_coefficient' in d:
            field_type = cls.__annotations__.get('restitution_coefficient')
            value = d['restitution_coefficient']
            
            if field_type is bytearray:
                obj.restitution_coefficient = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.restitution_coefficient = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.restitution_coefficient = value
            elif hasattr(field_type, 'from_dict'):
                obj.restitution_coefficient = field_type.from_dict(value)
            else:
                obj.restitution_coefficient = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
