from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class HakoBatteryStatus:
    """
    ROS message: hako_msgs/HakoBatteryStatus
    Generated by hakoniwa-ros2pdu.
    """

    full_voltage: float
    curr_voltage: float
    curr_temp: float
    status: int
    cycles: int

    def __init__(self):
        self.full_voltage = 0.0
        self.curr_voltage = 0.0
        self.curr_temp = 0.0
        self.status = 0
        self.cycles = 0

    def __str__(self):
        return f"HakoBatteryStatus(" + ", ".join([
            f"full_voltage={self.full_voltage}"
            f"curr_voltage={self.curr_voltage}"
            f"curr_temp={self.curr_temp}"
            f"status={self.status}"
            f"cycles={self.cycles}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'full_voltage'
        field_val = self.full_voltage
        if isinstance(field_val, bytearray):
            d['full_voltage'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['full_voltage'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['full_voltage'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['full_voltage'] = field_val
        # handle field 'curr_voltage'
        field_val = self.curr_voltage
        if isinstance(field_val, bytearray):
            d['curr_voltage'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['curr_voltage'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['curr_voltage'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['curr_voltage'] = field_val
        # handle field 'curr_temp'
        field_val = self.curr_temp
        if isinstance(field_val, bytearray):
            d['curr_temp'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['curr_temp'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['curr_temp'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['curr_temp'] = field_val
        # handle field 'status'
        field_val = self.status
        if isinstance(field_val, bytearray):
            d['status'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['status'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['status'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['status'] = field_val
        # handle field 'cycles'
        field_val = self.cycles
        if isinstance(field_val, bytearray):
            d['cycles'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['cycles'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['cycles'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['cycles'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'full_voltage'
        if 'full_voltage' in d:
            field_type = cls.__annotations__.get('full_voltage')
            value = d['full_voltage']
            
            if field_type is bytearray:
                obj.full_voltage = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.full_voltage = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.full_voltage = value
            elif hasattr(field_type, 'from_dict'):
                obj.full_voltage = field_type.from_dict(value)
            else:
                obj.full_voltage = value
        # handle field 'curr_voltage'
        if 'curr_voltage' in d:
            field_type = cls.__annotations__.get('curr_voltage')
            value = d['curr_voltage']
            
            if field_type is bytearray:
                obj.curr_voltage = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.curr_voltage = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.curr_voltage = value
            elif hasattr(field_type, 'from_dict'):
                obj.curr_voltage = field_type.from_dict(value)
            else:
                obj.curr_voltage = value
        # handle field 'curr_temp'
        if 'curr_temp' in d:
            field_type = cls.__annotations__.get('curr_temp')
            value = d['curr_temp']
            
            if field_type is bytearray:
                obj.curr_temp = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.curr_temp = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.curr_temp = value
            elif hasattr(field_type, 'from_dict'):
                obj.curr_temp = field_type.from_dict(value)
            else:
                obj.curr_temp = value
        # handle field 'status'
        if 'status' in d:
            field_type = cls.__annotations__.get('status')
            value = d['status']
            
            if field_type is bytearray:
                obj.status = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.status = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.status = value
            elif hasattr(field_type, 'from_dict'):
                obj.status = field_type.from_dict(value)
            else:
                obj.status = value
        # handle field 'cycles'
        if 'cycles' in d:
            field_type = cls.__annotations__.get('cycles')
            value = d['cycles']
            
            if field_type is bytearray:
                obj.cycles = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.cycles = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.cycles = value
            elif hasattr(field_type, 'from_dict'):
                obj.cycles = field_type.from_dict(value)
            else:
                obj.cycles = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
