from typing import List

# dependencies for the generated Python class
from ..sensor_msgs.pdu_pytype_CompressedImage import CompressedImage
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class MonitorCameraData:
    """
    ROS message: hako_msgs/MonitorCameraData
    Generated by hakoniwa-ros2pdu.
    """

    request_id: int
    image_data_length: int
    image: CompressedImage

    def __init__(self):
        self.request_id = 0
        self.image_data_length = 0
        self.image = CompressedImage()

    def __str__(self):
        return f"MonitorCameraData(" + ", ".join([
            f"request_id={self.request_id}"
            f"image_data_length={self.image_data_length}"
            f"image={self.image}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'request_id'
        field_val = self.request_id
        if isinstance(field_val, bytearray):
            d['request_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['request_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['request_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['request_id'] = field_val
        # handle field 'image_data_length'
        field_val = self.image_data_length
        if isinstance(field_val, bytearray):
            d['image_data_length'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['image_data_length'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['image_data_length'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['image_data_length'] = field_val
        # handle field 'image'
        field_val = self.image
        if isinstance(field_val, bytearray):
            d['image'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['image'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['image'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['image'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'request_id'
        if 'request_id' in d:
            field_type = cls.__annotations__.get('request_id')
            value = d['request_id']
            
            if field_type is bytearray:
                obj.request_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.request_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.request_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.request_id = field_type.from_dict(value)
            else:
                obj.request_id = value
        # handle field 'image_data_length'
        if 'image_data_length' in d:
            field_type = cls.__annotations__.get('image_data_length')
            value = d['image_data_length']
            
            if field_type is bytearray:
                obj.image_data_length = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.image_data_length = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.image_data_length = value
            elif hasattr(field_type, 'from_dict'):
                obj.image_data_length = field_type.from_dict(value)
            else:
                obj.image_data_length = value
        # handle field 'image'
        if 'image' in d:
            field_type = cls.__annotations__.get('image')
            value = d['image']
            
            if field_type is bytearray:
                obj.image = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.image = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.image = value
            elif hasattr(field_type, 'from_dict'):
                obj.image = field_type.from_dict(value)
            else:
                obj.image = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
