from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class ShareObjectOwnerResponse:
    """
    ROS message: hako_msgs/ShareObjectOwnerResponse
    Generated by hakoniwa-ros2pdu.
    """

    object_name: str
    request_type: int
    owner_id: int
    accepted: bool

    def __init__(self):
        self.object_name = ""
        self.request_type = 0
        self.owner_id = 0
        self.accepted = False

    def __str__(self):
        return f"ShareObjectOwnerResponse(" + ", ".join([
            f"object_name={self.object_name}"
            f"request_type={self.request_type}"
            f"owner_id={self.owner_id}"
            f"accepted={self.accepted}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'object_name'
        field_val = self.object_name
        if isinstance(field_val, bytearray):
            d['object_name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['object_name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['object_name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['object_name'] = field_val
        # handle field 'request_type'
        field_val = self.request_type
        if isinstance(field_val, bytearray):
            d['request_type'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['request_type'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['request_type'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['request_type'] = field_val
        # handle field 'owner_id'
        field_val = self.owner_id
        if isinstance(field_val, bytearray):
            d['owner_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['owner_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['owner_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['owner_id'] = field_val
        # handle field 'accepted'
        field_val = self.accepted
        if isinstance(field_val, bytearray):
            d['accepted'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['accepted'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['accepted'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['accepted'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'object_name'
        if 'object_name' in d:
            field_type = cls.__annotations__.get('object_name')
            value = d['object_name']
            
            if field_type is bytearray:
                obj.object_name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.object_name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.object_name = value
            elif hasattr(field_type, 'from_dict'):
                obj.object_name = field_type.from_dict(value)
            else:
                obj.object_name = value
        # handle field 'request_type'
        if 'request_type' in d:
            field_type = cls.__annotations__.get('request_type')
            value = d['request_type']
            
            if field_type is bytearray:
                obj.request_type = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.request_type = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.request_type = value
            elif hasattr(field_type, 'from_dict'):
                obj.request_type = field_type.from_dict(value)
            else:
                obj.request_type = value
        # handle field 'owner_id'
        if 'owner_id' in d:
            field_type = cls.__annotations__.get('owner_id')
            value = d['owner_id']
            
            if field_type is bytearray:
                obj.owner_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.owner_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.owner_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.owner_id = field_type.from_dict(value)
            else:
                obj.owner_id = value
        # handle field 'accepted'
        if 'accepted' in d:
            field_type = cls.__annotations__.get('accepted')
            value = d['accepted']
            
            if field_type is bytearray:
                obj.accepted = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.accepted = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.accepted = value
            elif hasattr(field_type, 'from_dict'):
                obj.accepted = field_type.from_dict(value)
            else:
                obj.accepted = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
