from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class AttitudeTarget:
    """
    ROS message: mavros_msgs/AttitudeTarget
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    type_mask: int
    orientation: Quaternion
    body_rate: Vector3
    thrust: float

    def __init__(self):
        self.header = Header()
        self.type_mask = 0
        self.orientation = Quaternion()
        self.body_rate = Vector3()
        self.thrust = 0.0

    def __str__(self):
        return f"AttitudeTarget(" + ", ".join([
            f"header={self.header}"
            f"type_mask={self.type_mask}"
            f"orientation={self.orientation}"
            f"body_rate={self.body_rate}"
            f"thrust={self.thrust}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'type_mask'
        field_val = self.type_mask
        if isinstance(field_val, bytearray):
            d['type_mask'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['type_mask'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['type_mask'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['type_mask'] = field_val
        # handle field 'orientation'
        field_val = self.orientation
        if isinstance(field_val, bytearray):
            d['orientation'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['orientation'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['orientation'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['orientation'] = field_val
        # handle field 'body_rate'
        field_val = self.body_rate
        if isinstance(field_val, bytearray):
            d['body_rate'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['body_rate'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['body_rate'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['body_rate'] = field_val
        # handle field 'thrust'
        field_val = self.thrust
        if isinstance(field_val, bytearray):
            d['thrust'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['thrust'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['thrust'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['thrust'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'type_mask'
        if 'type_mask' in d:
            field_type = cls.__annotations__.get('type_mask')
            value = d['type_mask']
            
            if field_type is bytearray:
                obj.type_mask = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.type_mask = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.type_mask = value
            elif hasattr(field_type, 'from_dict'):
                obj.type_mask = field_type.from_dict(value)
            else:
                obj.type_mask = value
        # handle field 'orientation'
        if 'orientation' in d:
            field_type = cls.__annotations__.get('orientation')
            value = d['orientation']
            
            if field_type is bytearray:
                obj.orientation = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.orientation = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.orientation = value
            elif hasattr(field_type, 'from_dict'):
                obj.orientation = field_type.from_dict(value)
            else:
                obj.orientation = value
        # handle field 'body_rate'
        if 'body_rate' in d:
            field_type = cls.__annotations__.get('body_rate')
            value = d['body_rate']
            
            if field_type is bytearray:
                obj.body_rate = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.body_rate = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.body_rate = value
            elif hasattr(field_type, 'from_dict'):
                obj.body_rate = field_type.from_dict(value)
            else:
                obj.body_rate = value
        # handle field 'thrust'
        if 'thrust' in d:
            field_type = cls.__annotations__.get('thrust')
            value = d['thrust']
            
            if field_type is bytearray:
                obj.thrust = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.thrust = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.thrust = value
            elif hasattr(field_type, 'from_dict'):
                obj.thrust = field_type.from_dict(value)
            else:
                obj.thrust = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
