from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..sensor_msgs.pdu_pytype_RegionOfInterest import RegionOfInterest
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class CameraInfo:
    """
    ROS message: sensor_msgs/CameraInfo
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    height: int
    width: int
    distortion_model: str
    d: List[float]
    k: List[float]
    r: List[float]
    p: List[float]
    binning_x: int
    binning_y: int
    roi: RegionOfInterest

    def __init__(self):
        self.header = Header()
        self.height = 0
        self.width = 0
        self.distortion_model = ""
        self.d = []
        self.k = []
        self.r = []
        self.p = []
        self.binning_x = 0
        self.binning_y = 0
        self.roi = RegionOfInterest()

    def __str__(self):
        return f"CameraInfo(" + ", ".join([
            f"header={self.header}"
            f"height={self.height}"
            f"width={self.width}"
            f"distortion_model={self.distortion_model}"
            f"d={self.d}"
            f"k={self.k}"
            f"r={self.r}"
            f"p={self.p}"
            f"binning_x={self.binning_x}"
            f"binning_y={self.binning_y}"
            f"roi={self.roi}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'height'
        field_val = self.height
        if isinstance(field_val, bytearray):
            d['height'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['height'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['height'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['height'] = field_val
        # handle field 'width'
        field_val = self.width
        if isinstance(field_val, bytearray):
            d['width'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['width'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['width'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['width'] = field_val
        # handle field 'distortion_model'
        field_val = self.distortion_model
        if isinstance(field_val, bytearray):
            d['distortion_model'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['distortion_model'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['distortion_model'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['distortion_model'] = field_val
        # handle field 'd'
        field_val = self.d
        if isinstance(field_val, bytearray):
            d['d'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['d'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['d'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['d'] = field_val
        # handle field 'k'
        field_val = self.k
        if isinstance(field_val, bytearray):
            d['k'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['k'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['k'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['k'] = field_val
        # handle field 'r'
        field_val = self.r
        if isinstance(field_val, bytearray):
            d['r'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['r'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['r'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['r'] = field_val
        # handle field 'p'
        field_val = self.p
        if isinstance(field_val, bytearray):
            d['p'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['p'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['p'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['p'] = field_val
        # handle field 'binning_x'
        field_val = self.binning_x
        if isinstance(field_val, bytearray):
            d['binning_x'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['binning_x'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['binning_x'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['binning_x'] = field_val
        # handle field 'binning_y'
        field_val = self.binning_y
        if isinstance(field_val, bytearray):
            d['binning_y'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['binning_y'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['binning_y'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['binning_y'] = field_val
        # handle field 'roi'
        field_val = self.roi
        if isinstance(field_val, bytearray):
            d['roi'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['roi'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['roi'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['roi'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'height'
        if 'height' in d:
            field_type = cls.__annotations__.get('height')
            value = d['height']
            
            if field_type is bytearray:
                obj.height = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.height = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.height = value
            elif hasattr(field_type, 'from_dict'):
                obj.height = field_type.from_dict(value)
            else:
                obj.height = value
        # handle field 'width'
        if 'width' in d:
            field_type = cls.__annotations__.get('width')
            value = d['width']
            
            if field_type is bytearray:
                obj.width = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.width = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.width = value
            elif hasattr(field_type, 'from_dict'):
                obj.width = field_type.from_dict(value)
            else:
                obj.width = value
        # handle field 'distortion_model'
        if 'distortion_model' in d:
            field_type = cls.__annotations__.get('distortion_model')
            value = d['distortion_model']
            
            if field_type is bytearray:
                obj.distortion_model = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.distortion_model = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.distortion_model = value
            elif hasattr(field_type, 'from_dict'):
                obj.distortion_model = field_type.from_dict(value)
            else:
                obj.distortion_model = value
        # handle field 'd'
        if 'd' in d:
            field_type = cls.__annotations__.get('d')
            value = d['d']
            
            if field_type is bytearray:
                obj.d = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.d = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.d = value
            elif hasattr(field_type, 'from_dict'):
                obj.d = field_type.from_dict(value)
            else:
                obj.d = value
        # handle field 'k'
        if 'k' in d:
            field_type = cls.__annotations__.get('k')
            value = d['k']
            
            if field_type is bytearray:
                obj.k = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.k = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.k = value
            elif hasattr(field_type, 'from_dict'):
                obj.k = field_type.from_dict(value)
            else:
                obj.k = value
        # handle field 'r'
        if 'r' in d:
            field_type = cls.__annotations__.get('r')
            value = d['r']
            
            if field_type is bytearray:
                obj.r = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.r = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.r = value
            elif hasattr(field_type, 'from_dict'):
                obj.r = field_type.from_dict(value)
            else:
                obj.r = value
        # handle field 'p'
        if 'p' in d:
            field_type = cls.__annotations__.get('p')
            value = d['p']
            
            if field_type is bytearray:
                obj.p = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.p = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.p = value
            elif hasattr(field_type, 'from_dict'):
                obj.p = field_type.from_dict(value)
            else:
                obj.p = value
        # handle field 'binning_x'
        if 'binning_x' in d:
            field_type = cls.__annotations__.get('binning_x')
            value = d['binning_x']
            
            if field_type is bytearray:
                obj.binning_x = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.binning_x = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.binning_x = value
            elif hasattr(field_type, 'from_dict'):
                obj.binning_x = field_type.from_dict(value)
            else:
                obj.binning_x = value
        # handle field 'binning_y'
        if 'binning_y' in d:
            field_type = cls.__annotations__.get('binning_y')
            value = d['binning_y']
            
            if field_type is bytearray:
                obj.binning_y = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.binning_y = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.binning_y = value
            elif hasattr(field_type, 'from_dict'):
                obj.binning_y = field_type.from_dict(value)
            else:
                obj.binning_y = value
        # handle field 'roi'
        if 'roi' in d:
            field_type = cls.__annotations__.get('roi')
            value = d['roi']
            
            if field_type is bytearray:
                obj.roi = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.roi = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.roi = value
            elif hasattr(field_type, 'from_dict'):
                obj.roi = field_type.from_dict(value)
            else:
                obj.roi = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
