from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class CompressedImage:
    """
    ROS message: sensor_msgs/CompressedImage
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    format: str
    data: List[int]

    def __init__(self):
        self.header = Header()
        self.format = ""
        self.data = []

    def __str__(self):
        return f"CompressedImage(" + ", ".join([
            f"header={self.header}"
            f"format={self.format}"
            f"data={self.data}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'format'
        field_val = self.format
        if isinstance(field_val, bytearray):
            d['format'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['format'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['format'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['format'] = field_val
        # handle field 'data'
        field_val = self.data
        if isinstance(field_val, bytearray):
            d['data'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['data'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['data'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['data'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'format'
        if 'format' in d:
            field_type = cls.__annotations__.get('format')
            value = d['format']
            
            if field_type is bytearray:
                obj.format = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.format = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.format = value
            elif hasattr(field_type, 'from_dict'):
                obj.format = field_type.from_dict(value)
            else:
                obj.format = value
        # handle field 'data'
        if 'data' in d:
            field_type = cls.__annotations__.get('data')
            value = d['data']
            
            if field_type is bytearray:
                obj.data = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.data = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.data = value
            elif hasattr(field_type, 'from_dict'):
                obj.data = field_type.from_dict(value)
            else:
                obj.data = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
