from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class Imu:
    """
    ROS message: sensor_msgs/Imu
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    orientation: Quaternion
    orientation_covariance: List[float]
    angular_velocity: Vector3
    angular_velocity_covariance: List[float]
    linear_acceleration: Vector3
    linear_acceleration_covariance: List[float]

    def __init__(self):
        self.header = Header()
        self.orientation = Quaternion()
        self.orientation_covariance = []
        self.angular_velocity = Vector3()
        self.angular_velocity_covariance = []
        self.linear_acceleration = Vector3()
        self.linear_acceleration_covariance = []

    def __str__(self):
        return f"Imu(" + ", ".join([
            f"header={self.header}"
            f"orientation={self.orientation}"
            f"orientation_covariance={self.orientation_covariance}"
            f"angular_velocity={self.angular_velocity}"
            f"angular_velocity_covariance={self.angular_velocity_covariance}"
            f"linear_acceleration={self.linear_acceleration}"
            f"linear_acceleration_covariance={self.linear_acceleration_covariance}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'orientation'
        field_val = self.orientation
        if isinstance(field_val, bytearray):
            d['orientation'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['orientation'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['orientation'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['orientation'] = field_val
        # handle field 'orientation_covariance'
        field_val = self.orientation_covariance
        if isinstance(field_val, bytearray):
            d['orientation_covariance'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['orientation_covariance'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['orientation_covariance'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['orientation_covariance'] = field_val
        # handle field 'angular_velocity'
        field_val = self.angular_velocity
        if isinstance(field_val, bytearray):
            d['angular_velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angular_velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angular_velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angular_velocity'] = field_val
        # handle field 'angular_velocity_covariance'
        field_val = self.angular_velocity_covariance
        if isinstance(field_val, bytearray):
            d['angular_velocity_covariance'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['angular_velocity_covariance'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['angular_velocity_covariance'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['angular_velocity_covariance'] = field_val
        # handle field 'linear_acceleration'
        field_val = self.linear_acceleration
        if isinstance(field_val, bytearray):
            d['linear_acceleration'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['linear_acceleration'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['linear_acceleration'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['linear_acceleration'] = field_val
        # handle field 'linear_acceleration_covariance'
        field_val = self.linear_acceleration_covariance
        if isinstance(field_val, bytearray):
            d['linear_acceleration_covariance'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['linear_acceleration_covariance'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['linear_acceleration_covariance'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['linear_acceleration_covariance'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'orientation'
        if 'orientation' in d:
            field_type = cls.__annotations__.get('orientation')
            value = d['orientation']
            
            if field_type is bytearray:
                obj.orientation = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.orientation = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.orientation = value
            elif hasattr(field_type, 'from_dict'):
                obj.orientation = field_type.from_dict(value)
            else:
                obj.orientation = value
        # handle field 'orientation_covariance'
        if 'orientation_covariance' in d:
            field_type = cls.__annotations__.get('orientation_covariance')
            value = d['orientation_covariance']
            
            if field_type is bytearray:
                obj.orientation_covariance = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.orientation_covariance = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.orientation_covariance = value
            elif hasattr(field_type, 'from_dict'):
                obj.orientation_covariance = field_type.from_dict(value)
            else:
                obj.orientation_covariance = value
        # handle field 'angular_velocity'
        if 'angular_velocity' in d:
            field_type = cls.__annotations__.get('angular_velocity')
            value = d['angular_velocity']
            
            if field_type is bytearray:
                obj.angular_velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angular_velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angular_velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.angular_velocity = field_type.from_dict(value)
            else:
                obj.angular_velocity = value
        # handle field 'angular_velocity_covariance'
        if 'angular_velocity_covariance' in d:
            field_type = cls.__annotations__.get('angular_velocity_covariance')
            value = d['angular_velocity_covariance']
            
            if field_type is bytearray:
                obj.angular_velocity_covariance = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.angular_velocity_covariance = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.angular_velocity_covariance = value
            elif hasattr(field_type, 'from_dict'):
                obj.angular_velocity_covariance = field_type.from_dict(value)
            else:
                obj.angular_velocity_covariance = value
        # handle field 'linear_acceleration'
        if 'linear_acceleration' in d:
            field_type = cls.__annotations__.get('linear_acceleration')
            value = d['linear_acceleration']
            
            if field_type is bytearray:
                obj.linear_acceleration = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.linear_acceleration = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.linear_acceleration = value
            elif hasattr(field_type, 'from_dict'):
                obj.linear_acceleration = field_type.from_dict(value)
            else:
                obj.linear_acceleration = value
        # handle field 'linear_acceleration_covariance'
        if 'linear_acceleration_covariance' in d:
            field_type = cls.__annotations__.get('linear_acceleration_covariance')
            value = d['linear_acceleration_covariance']
            
            if field_type is bytearray:
                obj.linear_acceleration_covariance = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.linear_acceleration_covariance = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.linear_acceleration_covariance = value
            elif hasattr(field_type, 'from_dict'):
                obj.linear_acceleration_covariance = field_type.from_dict(value)
            else:
                obj.linear_acceleration_covariance = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
