from typing import List

# dependencies for the generated Python class
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class Header:
    """
    ROS message: std_msgs/Header
    Generated by hakoniwa-ros2pdu.
    """

    stamp: Time
    frame_id: str

    def __init__(self):
        self.stamp = Time()
        self.frame_id = ""

    def __str__(self):
        return f"Header(" + ", ".join([
            f"stamp={self.stamp}"
            f"frame_id={self.frame_id}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'stamp'
        field_val = self.stamp
        if isinstance(field_val, bytearray):
            d['stamp'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['stamp'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['stamp'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['stamp'] = field_val
        # handle field 'frame_id'
        field_val = self.frame_id
        if isinstance(field_val, bytearray):
            d['frame_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['frame_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['frame_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['frame_id'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'stamp'
        if 'stamp' in d:
            field_type = cls.__annotations__.get('stamp')
            value = d['stamp']
            
            if field_type is bytearray:
                obj.stamp = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.stamp = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.stamp = value
            elif hasattr(field_type, 'from_dict'):
                obj.stamp = field_type.from_dict(value)
            else:
                obj.stamp = value
        # handle field 'frame_id'
        if 'frame_id' in d:
            field_type = cls.__annotations__.get('frame_id')
            value = d['frame_id']
            
            if field_type is bytearray:
                obj.frame_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.frame_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.frame_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.frame_id = field_type.from_dict(value)
            else:
                obj.frame_id = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
