from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..geometry_msgs.pdu_pytype_Quaternion import Quaternion
from ..builtin_interfaces.pdu_pytype_Time import Time
from ..geometry_msgs.pdu_pytype_Transform import Transform
from ..geometry_msgs.pdu_pytype_TransformStamped import TransformStamped
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class TFMessage:
    """
    ROS message: tf2_msgs/TFMessage
    Generated by hakoniwa-ros2pdu.
    """

    transforms: List[TransformStamped]

    def __init__(self):
        self.transforms = []

    def __str__(self):
        return f"TFMessage(" + ", ".join([
            f"transforms={self.transforms}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'transforms'
        field_val = self.transforms
        if isinstance(field_val, bytearray):
            d['transforms'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['transforms'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['transforms'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['transforms'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'transforms'
        if 'transforms' in d:
            field_type = cls.__annotations__.get('transforms')
            value = d['transforms']
            
            if field_type is bytearray:
                obj.transforms = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.transforms = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.transforms = value
            elif hasattr(field_type, 'from_dict'):
                obj.transforms = field_type.from_dict(value)
            else:
                obj.transforms = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
