const e=new class{constructor(){this.modal=null,this.currentNode=null,this.socket=null,this.initialized=!1,this.codeCache=new Map}initialize(){this.initialized||(this.createModal(),this.setupEventHandlers(),this.subscribeToEvents(),this.initialized=!0,console.log("Code viewer initialized"))}createModal(){document.body.insertAdjacentHTML("beforeend",'\n            <div class="code-viewer-modal" id="code-viewer-modal">\n                <div class="code-viewer-content">\n                    <div class="code-viewer-header">\n                        <div class="code-viewer-title" id="code-viewer-title">\n                            Loading...\n                        </div>\n                        <div class="code-viewer-info">\n                            <span id="code-viewer-type">Type: --</span>\n                            <span id="code-viewer-lines">Lines: --</span>\n                            <span id="code-viewer-complexity">Complexity: --</span>\n                        </div>\n                        <button class="code-viewer-close" id="code-viewer-close">×</button>\n                    </div>\n                    <div class="code-viewer-body">\n                        <pre class="code-viewer-code line-numbers" id="code-viewer-code">\n                            <code class="language-python" id="code-viewer-code-content"></code>\n                        </pre>\n                    </div>\n                    <div class="code-viewer-navigation">\n                        <div class="nav-group">\n                            <button class="code-nav-button" id="code-nav-parent" disabled>\n                                ⬆️ Parent\n                            </button>\n                            <button class="code-nav-button" id="code-nav-prev" disabled>\n                                ⬅️ Previous\n                            </button>\n                            <button class="code-nav-button" id="code-nav-next" disabled>\n                                ➡️ Next\n                            </button>\n                        </div>\n                        <div class="nav-info">\n                            <span id="code-nav-position">-- / --</span>\n                        </div>\n                        <div class="nav-actions">\n                            <button class="code-nav-button" id="code-copy">\n                                📋 Copy\n                            </button>\n                            <button class="code-nav-button" id="code-open-file">\n                                📂 Open File\n                            </button>\n                        </div>\n                    </div>\n                </div>\n            </div>\n        '),this.modal=document.getElementById("code-viewer-modal")}setupEventHandlers(){document.getElementById("code-viewer-close").addEventListener("click",()=>{this.hide()}),this.modal.addEventListener("click",e=>{e.target===this.modal&&this.hide()}),document.addEventListener("keydown",e=>{"Escape"===e.key&&this.modal.classList.contains("show")&&this.hide()}),document.getElementById("code-nav-parent").addEventListener("click",()=>{this.navigateToParent()}),document.getElementById("code-nav-prev").addEventListener("click",()=>{this.navigateToPrevious()}),document.getElementById("code-nav-next").addEventListener("click",()=>{this.navigateToNext()}),document.getElementById("code-copy").addEventListener("click",()=>{this.copyCode()}),document.getElementById("code-open-file").addEventListener("click",()=>{this.openInEditor()})}subscribeToEvents(){window.socket&&(this.socket=window.socket,this.socket.on("code:content:response",e=>{this.handleCodeContent(e)}))}show(e){this.initialized||this.initialize(),this.currentNode=e,this.modal.classList.add("show"),this.updateHeader(e),this.loadCode(e),this.updateNavigation(e)}hide(){this.modal.classList.remove("show"),this.currentNode=null}updateHeader(e){document.getElementById("code-viewer-title").textContent=`${e.name} (${e.path||"Unknown"})`,document.getElementById("code-viewer-type").textContent=`Type: ${e.type}`,document.getElementById("code-viewer-lines").textContent=`Lines: ${e.lines||"--"}`,document.getElementById("code-viewer-complexity").textContent=`Complexity: ${e.complexity||"--"}`}loadCode(e){const t=document.getElementById("code-viewer-code-content"),n=`${e.path}:${e.line}`;this.codeCache.has(n)?this.displayCode(this.codeCache.get(n)):(t.textContent="Loading code...",this.socket?this.socket.emit("code:content:request",{path:e.path,line:e.line,type:e.type,name:e.name}):this.displayMockCode(e))}handleCodeContent(e){if(!e.success)return void this.displayError(e.error||"Failed to load code");const t=`${e.path}:${e.line}`;this.codeCache.set(t,e.content),this.displayCode(e.content)}displayCode(e){const t=document.getElementById("code-viewer-code-content"),n=document.getElementById("code-viewer-code");t.textContent=e;const i=this.detectLanguage(this.currentNode.path);t.className=`language-${i}`,window.Prism&&(Prism.highlightElement(t),Prism.plugins&&Prism.plugins.lineNumbers&&Prism.plugins.lineNumbers.resize(n))}displayMockCode(e){let t="";switch(e.type){case"class":t=`class ${e.name}:\n    """\n    ${e.docstring||"A sample class implementation."}\n    """\n    \n    def __init__(self):\n        """Initialize the ${e.name} class."""\n        self._data = {}\n        self._initialized = False\n    \n    def process(self, input_data):\n        """Process the input data."""\n        if not self._initialized:\n            self._initialize()\n        return self._transform(input_data)\n    \n    def _initialize(self):\n        """Initialize internal state."""\n        self._initialized = True\n    \n    def _transform(self, data):\n        """Transform the data."""\n        return data`;break;case"function":t=`def ${e.name}(${e.params?e.params.join(", "):""}):\n    """\n    ${e.docstring||"A sample function implementation."}\n    \n    Args:\n        ${e.params?e.params.map(e=>`${e}: Description of ${e}`).join("\n        "):"None"}\n    \n    Returns:\n        ${e.returns||"None"}: Return value description\n    """\n    # Implementation here\n    result = None\n    \n    # Process logic\n    for item in range(10):\n        result = process_item(item)\n    \n    return result`;break;case"method":t=`    def ${e.name}(self${e.params?", "+e.params.join(", "):""}):\n        """\n        ${e.docstring||"A sample method implementation."}\n        """\n        # Method implementation\n        self._validate()\n        result = self._process()\n        return result`;break;default:t=`# ${e.name}\n# Type: ${e.type}\n# Path: ${e.path||"Unknown"}\n# Line: ${e.line||"Unknown"}\n\n# Code content would appear here\n# This is a placeholder for demonstration purposes`}this.displayCode(t)}displayError(e){const t=document.getElementById("code-viewer-code-content");t.textContent=`# Error loading code\n# ${e}`,t.className="language-python"}detectLanguage(e){if(!e)return"python";return{py:"python",js:"javascript",ts:"typescript",jsx:"jsx",tsx:"tsx",css:"css",html:"html",json:"json",yaml:"yaml",yml:"yaml",md:"markdown",sh:"bash",bash:"bash",sql:"sql",go:"go",rs:"rust",cpp:"cpp",c:"c",h:"c",hpp:"cpp",java:"java",rb:"ruby",php:"php"}[e.split(".").pop().toLowerCase()]||"plaintext"}updateNavigation(e){document.getElementById("code-nav-parent").disabled=!0,document.getElementById("code-nav-prev").disabled=!0,document.getElementById("code-nav-next").disabled=!0,document.getElementById("code-nav-position").textContent="1 / 1"}navigateToParent(){console.log("Navigate to parent node")}navigateToPrevious(){console.log("Navigate to previous sibling")}navigateToNext(){console.log("Navigate to next sibling")}async copyCode(){const e=document.getElementById("code-viewer-code-content").textContent;try{await navigator.clipboard.writeText(e);const t=document.getElementById("code-copy"),n=t.textContent;t.textContent="✅ Copied!",setTimeout(()=>{t.textContent=n},2e3)}catch(t){console.error("Failed to copy code:",t),alert("Failed to copy code to clipboard")}}openInEditor(){this.currentNode&&this.currentNode.path?(this.socket&&this.socket.emit("file:open",{path:this.currentNode.path,line:this.currentNode.line}),console.log("Opening file in editor:",this.currentNode.path)):alert("File path not available")}};"undefined"!=typeof window&&(window.CodeViewer=e,document.addEventListener("DOMContentLoaded",()=>{e.initialize()}));
//# sourceMappingURL=code-viewer.js.map
