"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmNamingStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const IAlarmDedupeStringProcessor_1 = require("./IAlarmDedupeStringProcessor");
const AlarmNamePartSeparator = "-";
const AlarmLabelPartSeparator = " ";
class AlarmNamingStrategy {
    constructor(globalPrefix, localPrefix, dedupeStringStrategy) {
        this.globalPrefix = globalPrefix;
        this.localPrefix = localPrefix;
        this.dedupeStringStrategy = dedupeStringStrategy !== null && dedupeStringStrategy !== void 0 ? dedupeStringStrategy : new IAlarmDedupeStringProcessor_1.DoNotModifyDedupeString();
    }
    /**
     * Alarm name is resolved like this:
     * - If "alarmNameOverride" is defined for an alarm, it will be used as alarm name.
     * - Otherwise, the alarm name will be generated by joining: global prefix, local prefix, alarm name suffix, disambiguator.
     *
     * @param props properties
     */
    getName(props) {
        if (props.alarmNameOverride) {
            return props.alarmNameOverride;
        }
        const parts = [
            this.globalPrefix,
            this.localPrefix,
            props.alarmNameSuffix,
        ];
        if (props.disambiguator) {
            parts.push(props.disambiguator);
        }
        return this.joinDistinct(parts, AlarmNamePartSeparator);
    }
    getWidgetLabel(props) {
        // not using global prefix to make the label shorter
        const parts = [this.localPrefix, props.alarmNameSuffix];
        if (props.disambiguator) {
            parts.push(props.disambiguator);
        }
        return this.joinDistinct(parts, AlarmLabelPartSeparator);
    }
    /**
     * Dedupe string resolved like this:
     * - If "dedupeStringOverride" is defined for an alarm, it will be used as a dedupe string.
     * - If "alarmDedupeStringSuffix" from the alarm factory is defined, "GlobalPrefix-LocalPrefix-AlarmDedupeStringSuffix" will be used as a dedupe string.
     * - Otherwise, the alarm dedupe string will not be set.
     * If a dedupe string strategy is set, it will be used to process the final string.
     *
     * @param props properties
     */
    getDedupeString(props) {
        if (props.dedupeStringOverride) {
            return this.dedupeStringStrategy.processDedupeStringOverride(props.dedupeStringOverride);
        }
        if (props.alarmDedupeStringSuffix) {
            // not using disambiguator here as we are still alarming on the same thing
            const parts = [
                this.globalPrefix,
                this.localPrefix,
                props.alarmDedupeStringSuffix,
            ];
            const dedupeString = this.joinDistinct(parts, AlarmNamePartSeparator);
            return this.dedupeStringStrategy.processDedupeString(dedupeString);
        }
        return undefined;
    }
    joinDistinct(parts, separator) {
        return parts.filter((x, i, a) => a.indexOf(x) == i).join(separator);
    }
}
exports.AlarmNamingStrategy = AlarmNamingStrategy;
_a = JSII_RTTI_SYMBOL_1;
AlarmNamingStrategy[_a] = { fqn: "cdk-monitoring-constructs.AlarmNamingStrategy", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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