"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultAlarmAnnotationStrategy = exports.FillingAlarmAnnotationStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Annotation strategy that fills the annotation provided, using the input and user requirements.
 */
class FillingAlarmAnnotationStrategy {
    createAnnotation(props) {
        const annotation = this.createAnnotationToFill(props);
        if (props.fillAlarmRange) {
            return { ...annotation, fill: this.getAlarmingRangeShade(props) };
        }
        return annotation;
    }
    getAlarmingRangeShade(props) {
        switch (props.comparisonOperator) {
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_UPPER_THRESHOLD:
                // Fill background above the annotation line
                return aws_cloudwatch_1.Shading.ABOVE;
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD:
            case aws_cloudwatch_1.ComparisonOperator.LESS_THAN_LOWER_THRESHOLD:
                // Fill background below the annotation line
                return aws_cloudwatch_1.Shading.BELOW;
            default:
                return undefined;
        }
    }
}
exports.FillingAlarmAnnotationStrategy = FillingAlarmAnnotationStrategy;
_a = JSII_RTTI_SYMBOL_1;
FillingAlarmAnnotationStrategy[_a] = { fqn: "cdk-monitoring-constructs.FillingAlarmAnnotationStrategy", version: "1.6.2" };
/**
 * Default annotation strategy that returns the built-in alarm annotation.
 */
class DefaultAlarmAnnotationStrategy extends FillingAlarmAnnotationStrategy {
    createAnnotationToFill(props) {
        return props.alarm.toAnnotation();
    }
}
exports.DefaultAlarmAnnotationStrategy = DefaultAlarmAnnotationStrategy;
_b = JSII_RTTI_SYMBOL_1;
DefaultAlarmAnnotationStrategy[_b] = { fqn: "cdk-monitoring-constructs.DefaultAlarmAnnotationStrategy", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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