"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoNotModifyDedupeString = exports.ExtendDedupeString = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Dedupe string processor that adds prefix and/or suffix to the dedupe string.
 */
class ExtendDedupeString {
    constructor(prefix, suffix) {
        this.prefix = prefix !== null && prefix !== void 0 ? prefix : "";
        this.suffix = suffix !== null && suffix !== void 0 ? suffix : "";
    }
    processDedupeString(dedupeString) {
        return this.prefix + dedupeString + this.suffix;
    }
    processDedupeStringOverride(dedupeString) {
        return this.prefix + dedupeString + this.suffix;
    }
}
exports.ExtendDedupeString = ExtendDedupeString;
_a = JSII_RTTI_SYMBOL_1;
ExtendDedupeString[_a] = { fqn: "cdk-monitoring-constructs.ExtendDedupeString", version: "1.6.2" };
/**
 * Default dedupe strategy - does not add any prefix nor suffix.
 */
class DoNotModifyDedupeString extends ExtendDedupeString {
}
exports.DoNotModifyDedupeString = DoNotModifyDedupeString;
_b = JSII_RTTI_SYMBOL_1;
DoNotModifyDedupeString[_b] = { fqn: "cdk-monitoring-constructs.DoNotModifyDedupeString", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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