"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsAlarmActionStrategy = exports.notifySns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_actions_1 = require("aws-cdk-lib/aws-cloudwatch-actions");
function notifySns(onAlarmTopic, onOkTopic, onInsufficientDataTopic) {
    return new SnsAlarmActionStrategy({
        onAlarmTopic,
        onOkTopic,
        onInsufficientDataTopic,
    });
}
exports.notifySns = notifySns;
/**
 * Alarm action strategy that sends a notification to the specified SNS topic.
 */
class SnsAlarmActionStrategy {
    constructor(props) {
        this.onAlarmTopic = props.onAlarmTopic;
        this.onOkTopic = props.onOkTopic;
        this.onInsufficientDataTopic = props.onInsufficientDataTopic;
    }
    addAlarmActions(props) {
        props.alarm.addAlarmAction(new aws_cloudwatch_actions_1.SnsAction(this.onAlarmTopic));
        if (this.onOkTopic) {
            props.alarm.addOkAction(new aws_cloudwatch_actions_1.SnsAction(this.onOkTopic));
        }
        if (this.onInsufficientDataTopic) {
            props.alarm.addInsufficientDataAction(new aws_cloudwatch_actions_1.SnsAction(this.onInsufficientDataTopic));
        }
    }
}
exports.SnsAlarmActionStrategy = SnsAlarmActionStrategy;
_a = JSII_RTTI_SYMBOL_1;
SnsAlarmActionStrategy[_a] = { fqn: "cdk-monitoring-constructs.SnsAlarmActionStrategy", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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