"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnomalyDetectionMathExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Captures specific MathExpression for anomaly detection, for which alarm generation is different.
 * Added to overcome certain CDK limitations at the time of writing.
 * @see https://github.com/aws/aws-cdk/issues/10540
 */
class AnomalyDetectionMathExpression extends aws_cloudwatch_1.MathExpression {
    constructor(props) {
        super(props);
    }
    with(props) {
        var _b, _c, _d;
        return new AnomalyDetectionMathExpression({
            expression: this.expression,
            usingMetrics: this.usingMetrics,
            label: (_b = props.label) !== null && _b !== void 0 ? _b : this.label,
            color: (_c = props.color) !== null && _c !== void 0 ? _c : this.color,
            period: (_d = props.period) !== null && _d !== void 0 ? _d : this.period,
        });
    }
    createAlarm(scope, id, props) {
        const alarm = super.createAlarm(scope, id, props);
        // https://github.com/aws/aws-cdk/issues/10540#issuecomment-725222564
        const cfnAlarm = alarm.node.defaultChild;
        cfnAlarm.addPropertyDeletionOverride("Threshold");
        cfnAlarm.metrics.forEach((metric, index) => {
            if (metric.expression) {
                cfnAlarm.thresholdMetricId = metric.id;
            }
            cfnAlarm.addPropertyOverride(`Metrics.${index}.ReturnData`, true);
        });
        return alarm;
    }
}
exports.AnomalyDetectionMathExpression = AnomalyDetectionMathExpression;
_a = JSII_RTTI_SYMBOL_1;
AnomalyDetectionMathExpression[_a] = { fqn: "cdk-monitoring-constructs.AnomalyDetectionMathExpression", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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