"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.XaxrMathExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Custom wrapper class for MathExpression that supports account and region specification.
 * @see https://github.com/aws/aws-cdk/issues/9039
 */
class XaxrMathExpression {
    constructor(props) {
        this.props = props;
        this.mathExpression = new aws_cloudwatch_1.MathExpression(props);
    }
    with(options) {
        return new XaxrMathExpression({
            ...this.props,
            ...options,
        });
    }
    toMetricConfig() {
        const defaultMetricConfig = this.mathExpression.toMetricConfig();
        return {
            ...defaultMetricConfig,
            renderingProperties: {
                ...defaultMetricConfig.renderingProperties,
                accountId: this.props.account,
                region: this.props.region,
            },
        };
    }
}
exports.XaxrMathExpression = XaxrMathExpression;
_a = JSII_RTTI_SYMBOL_1;
XaxrMathExpression[_a] = { fqn: "cdk-monitoring-constructs.XaxrMathExpression", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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