"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Monitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An independent unit of monitoring. This is the base for all monitoring classes with alarm support.
 */
class Monitoring {
    constructor(scope, props) {
        this.scope = scope;
        this.alarms = [];
        this.localAlarmNamePrefixOverride = props === null || props === void 0 ? void 0 : props.localAlarmNamePrefixOverride;
    }
    /**
     * Creates a new widget factory.
     */
    createWidgetFactory() {
        return this.scope.createWidgetFactory();
    }
    /**
     * Creates a new metric factory.
     */
    createMetricFactory() {
        return this.scope.createMetricFactory();
    }
    /**
     * Creates a new alarm factory.
     * Alarms created will be named with the given prefix, unless a local name override is present.
     * @param alarmNamePrefix alarm name prefix
     */
    createAlarmFactory(alarmNamePrefix) {
        var _b;
        return this.scope.createAlarmFactory((_b = this.localAlarmNamePrefixOverride) !== null && _b !== void 0 ? _b : alarmNamePrefix);
    }
    /**
     * Adds an alarm.
     * @param alarm alarm to add
     */
    addAlarm(alarm) {
        this.alarms.push(alarm);
    }
    /**
     * Returns all the alarms created.
     */
    createdAlarms() {
        return this.alarms;
    }
    /**
     * Returns widgets for all alarms. These can go to runbook or to service dashboard.
     */
    alarmWidgets() {
        return this.createdAlarms().map((alarm) => this.createWidgetFactory().createAlarmDetailWidget(alarm));
    }
    /**
     * Returns widgets to be placed on the summary dashboard.
     *
     * @default no widgets.
     */
    summaryWidgets() {
        return [];
    }
}
exports.Monitoring = Monitoring;
_a = JSII_RTTI_SYMBOL_1;
Monitoring[_a] = { fqn: "cdk-monitoring-constructs.Monitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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