"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class CustomAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addCustomAlarm(metric, alarmNameSuffix, disambiguator, props) {
        var _b, _c, _d;
        return this.alarmFactory.addAlarm(metric, {
            ...props,
            disambiguator,
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            threshold: props.threshold,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : props.comparisonOperator,
            alarmDedupeStringSuffix: props.dedupeString,
            alarmNameSuffix,
            alarmDescription: (_d = props.additionalDescription) !== null && _d !== void 0 ? _d : `Threshold of ${props.threshold} has been breached.`,
        });
    }
}
exports.CustomAlarmFactory = CustomAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
CustomAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.CustomAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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