"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoAlarmFactory = exports.CapacityType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var CapacityType;
(function (CapacityType) {
    CapacityType["READ"] = "Read";
    CapacityType["WRITE"] = "Write";
})(CapacityType = exports.CapacityType || (exports.CapacityType = {}));
class DynamoAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addConsumedCapacityAlarm(metric, capacityType, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxConsumedCapacityUnits,
            alarmNameSuffix: `${capacityType}-Consumed-Capacity`,
            // we will dedupe any kind of error to the same ticket
            alarmDedupeStringSuffix: "ConsumedCapacity",
            alarmDescription: `${capacityType} consumed capacity is too high.`,
        });
    }
    addThrottledEventsAlarm(metric, capacityType, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxThrottledEventsThreshold,
            alarmNameSuffix: `${capacityType}-Throttled-Events`,
            // we will dedupe any kind of error to the same ticket
            alarmDedupeStringSuffix: "ThrottledEvents",
            alarmDescription: `${capacityType} throttled events above threshold.`,
        });
    }
}
exports.DynamoAlarmFactory = DynamoAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
DynamoAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.DynamoAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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