"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorAlarmFactory = exports.ErrorType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var ErrorType;
(function (ErrorType) {
    ErrorType["FAULT"] = "Fault";
    ErrorType["ERROR"] = "Error";
    ErrorType["SYSTEM_ERROR"] = "SystemError";
    ErrorType["USER_ERROR"] = "UserError";
    ErrorType["FAILURE"] = "Failure";
    ErrorType["ABORTED"] = "Aborted";
    ErrorType["THROTTLED"] = "Throttled";
    ErrorType["TIMED_OUT"] = "TimedOut";
    ErrorType["READ_ERROR"] = "ReadError";
    ErrorType["WRITE_ERROR"] = "WriteError";
    ErrorType["EXPIRED"] = "Expired";
    ErrorType["KILLED"] = "Killed";
})(ErrorType = exports.ErrorType || (exports.ErrorType = {}));
class ErrorAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addErrorCountAlarm(metric, errorType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `${errorType}-Count`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxErrorCount,
            alarmNameSuffix,
            // we will dedupe any kind of error to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory.shouldUseDefaultDedupeForError
                ? "AnyError"
                : alarmNameSuffix,
            alarmDescription: `${errorType} count is too high.`,
        });
    }
    addErrorRateAlarm(metric, errorType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `${errorType}-Rate`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxErrorRate,
            alarmNameSuffix,
            // we will dedupe any kind of error to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory.shouldUseDefaultDedupeForError
                ? "AnyError"
                : alarmNameSuffix,
            alarmDescription: `${errorType} rate is too high.`,
        });
    }
}
exports.ErrorAlarmFactory = ErrorAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
ErrorAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.ErrorAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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