"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class KinesisAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addIteratorMaxAgeAlarm(metric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxAgeInMillis,
            alarmNameSuffix: "Iterator-Age-Max",
            alarmDescription: `Iterator Max Age is too high.`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "AnyDataStreamIteratorMaxAge",
        });
    }
    addPutRecordsThrottledAlarm(metric, props, disambiguator) {
        var _b, _c;
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: threshold,
            alarmNameSuffix: "PutRecordsThrottled",
            alarmDescription: `Number of throttled PutRecords exceeded threshold of ${threshold}`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "PutRecordsThrottled",
        });
    }
    addPutRecordsFailedAlarm(metric, props, disambiguator) {
        var _b, _c;
        const threshold = props.maxRecordsFailedThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "PutRecordsFailed",
            alarmDescription: `Number of failed PutRecords exceeded threshold of ${threshold}`,
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "PutRecordsFailed",
        });
    }
    addProvisionedReadThroughputExceededAlarm(metric, props, disambiguator) {
        var _b, _c;
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "ReadThroughputExceeded",
            alarmDescription: `Number of records resulting in read throughput capacity throttling reached the threshold of ${threshold}.`,
        });
    }
    addProvisionedWriteThroughputExceededAlarm(metric, props, disambiguator) {
        var _b, _c;
        const threshold = props.maxRecordsThrottledThreshold;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold,
            alarmNameSuffix: "WriteThroughputExceeded",
            alarmDescription: `Number of records resulting in write throughput capacity throttling reached the threshold of ${threshold}.`,
        });
    }
}
exports.KinesisAlarmFactory = KinesisAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
KinesisAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.KinesisAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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