"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataAnalyticsAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class KinesisDataAnalyticsAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addDowntimeAlarm(metric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxDowntimeInMillis,
            alarmNameSuffix: "Downtime",
            alarmDescription: "Application has too much downtime",
            // we will dedupe any kind of message count issue to the same ticket
            alarmDedupeStringSuffix: "KDADowntimeAlarm",
        });
    }
    addFullRestartAlarm(metric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxFullRestartCount,
            alarmNameSuffix: "FullRestart",
            alarmDescription: "Last submitted job is restarting more than usual",
            alarmDedupeStringSuffix: "KDAFullRestartAlarm",
        });
    }
}
exports.KinesisDataAnalyticsAlarmFactory = KinesisDataAnalyticsAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataAnalyticsAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.KinesisDataAnalyticsAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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