"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LatencyAlarmFactory = exports.getLatencyTypeLabel = exports.getLatencyTypeExpressionId = exports.getLatencyTypeStatistic = exports.LatencyType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const metric_1 = require("../../metric");
var LatencyType;
(function (LatencyType) {
    LatencyType["P50"] = "P50";
    LatencyType["P70"] = "P70";
    LatencyType["P90"] = "P90";
    LatencyType["P95"] = "P95";
    LatencyType["P99"] = "P99";
    LatencyType["P999"] = "P999";
    LatencyType["P9999"] = "P9999";
    LatencyType["P100"] = "P100";
    LatencyType["TM50"] = "TM50";
    LatencyType["TM70"] = "TM70";
    LatencyType["TM90"] = "TM90";
    LatencyType["TM95"] = "TM95";
    LatencyType["TM99"] = "TM99";
    LatencyType["TM999"] = "TM999";
    LatencyType["TM9999"] = "TM9999";
    LatencyType["AVERAGE"] = "Average";
})(LatencyType = exports.LatencyType || (exports.LatencyType = {}));
function getLatencyTypeStatistic(latencyType) {
    switch (latencyType) {
        case LatencyType.P50:
            return metric_1.MetricStatistic.P50;
        case LatencyType.P70:
            return metric_1.MetricStatistic.P70;
        case LatencyType.P90:
            return metric_1.MetricStatistic.P90;
        case LatencyType.P95:
            return metric_1.MetricStatistic.P95;
        case LatencyType.P99:
            return metric_1.MetricStatistic.P99;
        case LatencyType.P999:
            return metric_1.MetricStatistic.P999;
        case LatencyType.P9999:
            return metric_1.MetricStatistic.P9999;
        case LatencyType.P100:
            return metric_1.MetricStatistic.P100;
        case LatencyType.TM50:
            return metric_1.MetricStatistic.TM50;
        case LatencyType.TM70:
            return metric_1.MetricStatistic.TM70;
        case LatencyType.TM90:
            return metric_1.MetricStatistic.TM90;
        case LatencyType.TM95:
            return metric_1.MetricStatistic.TM95;
        case LatencyType.TM99:
            return metric_1.MetricStatistic.TM99;
        case LatencyType.TM999:
            return metric_1.MetricStatistic.TM999;
        case LatencyType.TM9999:
            return metric_1.MetricStatistic.TM9999;
        case LatencyType.AVERAGE:
            return metric_1.MetricStatistic.AVERAGE;
        default:
            throw new Error("Unsupported latency type (unknown statistic): " + latencyType);
    }
}
exports.getLatencyTypeStatistic = getLatencyTypeStatistic;
function getLatencyTypeExpressionId(latencyType) {
    switch (latencyType) {
        case LatencyType.P50:
        case LatencyType.P70:
        case LatencyType.P90:
        case LatencyType.P95:
        case LatencyType.P99:
        case LatencyType.P999:
        case LatencyType.P9999:
        case LatencyType.P100:
            // remove the P prefix
            return latencyType.substr(1);
        case LatencyType.AVERAGE:
            // making it shorter for backwards compatibility
            return "Avg";
        default:
            // use as-is
            return latencyType;
    }
}
exports.getLatencyTypeExpressionId = getLatencyTypeExpressionId;
function getLatencyTypeLabel(latencyType) {
    const averageSuffix = " (avg: ${AVG})";
    switch (latencyType) {
        case LatencyType.P999:
        case LatencyType.TM999:
            // we need proper decimal here
            return latencyType.replace("999", "99.9") + averageSuffix;
        case LatencyType.P9999:
        case LatencyType.TM9999:
            // we need proper decimal here
            return latencyType.replace("9999", "99.99") + averageSuffix;
        case LatencyType.AVERAGE:
            // no suffix here, since we already have average
            return "Average";
        default:
            // use as-is
            return latencyType + averageSuffix;
    }
}
exports.getLatencyTypeLabel = getLatencyTypeLabel;
class LatencyAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addLatencyAlarm(metric, latencyType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `Latency-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxLatency.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyLatency"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} latency is too high.`,
        });
    }
    addIntegrationLatencyAlarm(metric, latencyType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `IntegrationLatency-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxLatency.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same alarm
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyLatency"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} integration latency is too high.`,
        });
    }
    addDurationAlarm(metric, latencyType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `Duration-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxDuration.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyDuration"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} duration is too long.`,
        });
    }
    addJvmGarbageCollectionDurationAlarm(metric, latencyType, props, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = `Garbage-Collection-Time-${latencyType}`;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxDuration.toMilliseconds(),
            alarmNameSuffix,
            // we will dedupe any kind of latency issue to the same ticket
            alarmDedupeStringSuffix: this.alarmFactory
                .shouldUseDefaultDedupeForLatency
                ? "AnyDuration"
                : alarmNameSuffix,
            alarmDescription: `${latencyType} duration is too long.`,
        });
    }
}
exports.LatencyAlarmFactory = LatencyAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
LatencyAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.LatencyAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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