"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogLevelAlarmFactory = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * Level of a given log
 */
var LogLevel;
(function (LogLevel) {
    LogLevel["ERROR"] = "ERROR";
    LogLevel["CRITICAL"] = "CRITICAL";
    LogLevel["FATAL"] = "FATAL";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class LogLevelAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addLogCountAlarm(metric, logLevel, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxLogCount,
            alarmNameSuffix: `${LogLevel[logLevel]}-Logs-Count`,
            // we will dedupe any kind of error to the same ticket
            alarmDedupeStringSuffix: `${LogLevel[logLevel].toLowerCase()}`,
            alarmDescription: `${LogLevel[logLevel]} logs count is too high.`,
        });
    }
}
exports.LogLevelAlarmFactory = LogLevelAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
LogLevelAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.LogLevelAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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