"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThroughputAlarmFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class ThroughputAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addMinProcessedBytesAlarm(metric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(metric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.NOT_BREACHING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.LESS_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.minProcessedBytes,
            alarmNameSuffix: "Processed-Bytes-Min",
            alarmDescription: `Minimum number of processed bytes is too low.`,
        });
    }
}
exports.ThroughputAlarmFactory = ThroughputAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
ThroughputAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.ThroughputAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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