"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsageAlarmFactory = exports.UsageType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var UsageType;
(function (UsageType) {
    UsageType["P50"] = "P50";
    UsageType["P70"] = "P70";
    UsageType["P90"] = "P90";
    UsageType["P99"] = "P99";
    UsageType["P999"] = "P999";
    UsageType["P9999"] = "P9999";
    UsageType["P100"] = "P100";
    UsageType["AVERAGE"] = "Average";
    UsageType["MAX"] = "Maximum";
})(UsageType = exports.UsageType || (exports.UsageType = {}));
class UsageAlarmFactory {
    constructor(alarmFactory) {
        this.alarmFactory = alarmFactory;
    }
    addMaxCpuUsagePercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "CPU-Usage",
            alarmDescription: "The CPU usage is too high.",
        });
    }
    addMaxMasterCpuUsagePercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Master-CPU-Usage",
            alarmDescription: "The master CPU usage is too high.",
        });
    }
    addMaxMemoryUsagePercentAlarm(percentMetric, props, disambiguator) {
        return this.addMemoryUsagePercentAlarm(percentMetric, props, UsageType.MAX, disambiguator);
    }
    addMemoryUsagePercentAlarm(percentMetric, props, usageType, disambiguator) {
        var _b, _c;
        const alarmNameSuffix = usageType === UsageType.MAX
            ? "Memory-Usage"
            : `${usageType}-Memory-Usage`;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix,
            alarmDescription: "The memory usage is too high.",
        });
    }
    addMaxMasterMemoryUsagePercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Master-Memory-Usage",
            alarmDescription: "The master memory usage is too high.",
        });
    }
    addMaxDiskUsagePercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "Disk-Usage",
            alarmDescription: "The disk usage is too high.",
        });
    }
    addMaxHeapMemoryAfterGCUsagePercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "HeapMemoryAfterGC-Usage",
            alarmDescription: "The heap memory after GC usage is too high.",
        });
    }
    addMaxFileDescriptorPercentAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsagePercent,
            alarmNameSuffix: "File-Descriptor-Usage",
            alarmDescription: "The file descriptor usage is too high.",
        });
    }
    addMaxThreadCountUsageAlarm(percentMetric, props, disambiguator) {
        var _b, _c;
        return this.alarmFactory.addAlarm(percentMetric, {
            treatMissingData: (_b = props.treatMissingDataOverride) !== null && _b !== void 0 ? _b : aws_cloudwatch_1.TreatMissingData.MISSING,
            comparisonOperator: (_c = props.comparisonOperatorOverride) !== null && _c !== void 0 ? _c : aws_cloudwatch_1.ComparisonOperator.GREATER_THAN_THRESHOLD,
            ...props,
            disambiguator,
            threshold: props.maxUsageCount,
            alarmNameSuffix: "Thread-Count",
            alarmDescription: "The thread count is too high.",
        });
    }
}
exports.UsageAlarmFactory = UsageAlarmFactory;
_a = JSII_RTTI_SYMBOL_1;
UsageAlarmFactory[_a] = { fqn: "cdk-monitoring-constructs.UsageAlarmFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiVXNhZ2VBbGFybUZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJVc2FnZUFsYXJtRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtEQUdvQztBQUtwQyxJQUFZLFNBVVg7QUFWRCxXQUFZLFNBQVM7SUFDbkIsd0JBQVcsQ0FBQTtJQUNYLHdCQUFXLENBQUE7SUFDWCx3QkFBVyxDQUFBO0lBQ1gsd0JBQVcsQ0FBQTtJQUNYLDBCQUFhLENBQUE7SUFDYiw0QkFBZSxDQUFBO0lBQ2YsMEJBQWEsQ0FBQTtJQUNiLGdDQUFtQixDQUFBO0lBQ25CLDRCQUFlLENBQUE7QUFDakIsQ0FBQyxFQVZXLFNBQVMsR0FBVCxpQkFBUyxLQUFULGlCQUFTLFFBVXBCO0FBVUQsTUFBYSxpQkFBaUI7SUFHNUIsWUFBWSxZQUEwQjtRQUNwQyxJQUFJLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztJQUNuQyxDQUFDO0lBRUQsMEJBQTBCLENBQ3hCLGFBQXFDLEVBQ3JDLEtBQXFCLEVBQ3JCLGFBQXNCOztRQUV0QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRTtZQUMvQyxnQkFBZ0IsUUFDZCxLQUFLLENBQUMsd0JBQXdCLG1DQUFJLGlDQUFnQixDQUFDLE9BQU87WUFDNUQsa0JBQWtCLFFBQ2hCLEtBQUssQ0FBQywwQkFBMEIsbUNBQ2hDLG1DQUFrQixDQUFDLHNCQUFzQjtZQUMzQyxHQUFHLEtBQUs7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ2hDLGVBQWUsRUFBRSxXQUFXO1lBQzVCLGdCQUFnQixFQUFFLDRCQUE0QjtTQUMvQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsZ0NBQWdDLENBQzlCLGFBQXFDLEVBQ3JDLEtBQXFCLEVBQ3JCLGFBQXNCOztRQUV0QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRTtZQUMvQyxnQkFBZ0IsUUFDZCxLQUFLLENBQUMsd0JBQXdCLG1DQUFJLGlDQUFnQixDQUFDLE9BQU87WUFDNUQsa0JBQWtCLFFBQ2hCLEtBQUssQ0FBQywwQkFBMEIsbUNBQ2hDLG1DQUFrQixDQUFDLHNCQUFzQjtZQUMzQyxHQUFHLEtBQUs7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ2hDLGVBQWUsRUFBRSxrQkFBa0I7WUFDbkMsZ0JBQWdCLEVBQUUsbUNBQW1DO1NBQ3RELENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCw2QkFBNkIsQ0FDM0IsYUFBcUMsRUFDckMsS0FBcUIsRUFDckIsYUFBc0I7UUFFdEIsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQ3BDLGFBQWEsRUFDYixLQUFLLEVBQ0wsU0FBUyxDQUFDLEdBQUcsRUFDYixhQUFhLENBQ2QsQ0FBQztJQUNKLENBQUM7SUFFRCwwQkFBMEIsQ0FDeEIsYUFBcUMsRUFDckMsS0FBcUIsRUFDckIsU0FBb0IsRUFDcEIsYUFBc0I7O1FBRXRCLE1BQU0sZUFBZSxHQUNuQixTQUFTLEtBQUssU0FBUyxDQUFDLEdBQUc7WUFDekIsQ0FBQyxDQUFDLGNBQWM7WUFDaEIsQ0FBQyxDQUFDLEdBQUcsU0FBUyxlQUFlLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDL0MsZ0JBQWdCLFFBQ2QsS0FBSyxDQUFDLHdCQUF3QixtQ0FBSSxpQ0FBZ0IsQ0FBQyxPQUFPO1lBQzVELGtCQUFrQixRQUNoQixLQUFLLENBQUMsMEJBQTBCLG1DQUNoQyxtQ0FBa0IsQ0FBQyxzQkFBc0I7WUFDM0MsR0FBRyxLQUFLO1lBQ1IsYUFBYTtZQUNiLFNBQVMsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUNoQyxlQUFlO1lBQ2YsZ0JBQWdCLEVBQUUsK0JBQStCO1NBQ2xELENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxtQ0FBbUMsQ0FDakMsYUFBcUMsRUFDckMsS0FBcUIsRUFDckIsYUFBc0I7O1FBRXRCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsYUFBYSxFQUFFO1lBQy9DLGdCQUFnQixRQUNkLEtBQUssQ0FBQyx3QkFBd0IsbUNBQUksaUNBQWdCLENBQUMsT0FBTztZQUM1RCxrQkFBa0IsUUFDaEIsS0FBSyxDQUFDLDBCQUEwQixtQ0FDaEMsbUNBQWtCLENBQUMsc0JBQXNCO1lBQzNDLEdBQUcsS0FBSztZQUNSLGFBQWE7WUFDYixTQUFTLEVBQUUsS0FBSyxDQUFDLGVBQWU7WUFDaEMsZUFBZSxFQUFFLHFCQUFxQjtZQUN0QyxnQkFBZ0IsRUFBRSxzQ0FBc0M7U0FDekQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELDJCQUEyQixDQUN6QixhQUFxQyxFQUNyQyxLQUFxQixFQUNyQixhQUFzQjs7UUFFdEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDL0MsZ0JBQWdCLFFBQ2QsS0FBSyxDQUFDLHdCQUF3QixtQ0FBSSxpQ0FBZ0IsQ0FBQyxPQUFPO1lBQzVELGtCQUFrQixRQUNoQixLQUFLLENBQUMsMEJBQTBCLG1DQUNoQyxtQ0FBa0IsQ0FBQyxzQkFBc0I7WUFDM0MsR0FBRyxLQUFLO1lBQ1IsYUFBYTtZQUNiLFNBQVMsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUNoQyxlQUFlLEVBQUUsWUFBWTtZQUM3QixnQkFBZ0IsRUFBRSw2QkFBNkI7U0FDaEQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELHdDQUF3QyxDQUN0QyxhQUFxQyxFQUNyQyxLQUFxQixFQUNyQixhQUFzQjs7UUFFdEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEVBQUU7WUFDL0MsZ0JBQWdCLFFBQ2QsS0FBSyxDQUFDLHdCQUF3QixtQ0FBSSxpQ0FBZ0IsQ0FBQyxPQUFPO1lBQzVELGtCQUFrQixRQUNoQixLQUFLLENBQUMsMEJBQTBCLG1DQUNoQyxtQ0FBa0IsQ0FBQyxzQkFBc0I7WUFDM0MsR0FBRyxLQUFLO1lBQ1IsYUFBYTtZQUNiLFNBQVMsRUFBRSxLQUFLLENBQUMsZUFBZTtZQUNoQyxlQUFlLEVBQUUseUJBQXlCO1lBQzFDLGdCQUFnQixFQUFFLDZDQUE2QztTQUNoRSxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsZ0NBQWdDLENBQzlCLGFBQXFDLEVBQ3JDLEtBQXFCLEVBQ3JCLGFBQXNCOztRQUV0QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRTtZQUMvQyxnQkFBZ0IsUUFDZCxLQUFLLENBQUMsd0JBQXdCLG1DQUFJLGlDQUFnQixDQUFDLE9BQU87WUFDNUQsa0JBQWtCLFFBQ2hCLEtBQUssQ0FBQywwQkFBMEIsbUNBQ2hDLG1DQUFrQixDQUFDLHNCQUFzQjtZQUMzQyxHQUFHLEtBQUs7WUFDUixhQUFhO1lBQ2IsU0FBUyxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ2hDLGVBQWUsRUFBRSx1QkFBdUI7WUFDeEMsZ0JBQWdCLEVBQUUsd0NBQXdDO1NBQzNELENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCwyQkFBMkIsQ0FDekIsYUFBcUMsRUFDckMsS0FBMEIsRUFDMUIsYUFBc0I7O1FBRXRCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsYUFBYSxFQUFFO1lBQy9DLGdCQUFnQixRQUNkLEtBQUssQ0FBQyx3QkFBd0IsbUNBQUksaUNBQWdCLENBQUMsT0FBTztZQUM1RCxrQkFBa0IsUUFDaEIsS0FBSyxDQUFDLDBCQUEwQixtQ0FDaEMsbUNBQWtCLENBQUMsc0JBQXNCO1lBQzNDLEdBQUcsS0FBSztZQUNSLGFBQWE7WUFDYixTQUFTLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDOUIsZUFBZSxFQUFFLGNBQWM7WUFDL0IsZ0JBQWdCLEVBQUUsK0JBQStCO1NBQ2xELENBQUMsQ0FBQztJQUNMLENBQUM7O0FBL0tILDhDQWdMQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENvbXBhcmlzb25PcGVyYXRvcixcbiAgVHJlYXRNaXNzaW5nRGF0YSxcbn0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1jbG91ZHdhdGNoXCI7XG5cbmltcG9ydCB7IEFsYXJtRmFjdG9yeSwgQ3VzdG9tQWxhcm1UaHJlc2hvbGQgfSBmcm9tIFwiLi4vLi4vYWxhcm1cIjtcbmltcG9ydCB7IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQgfSBmcm9tIFwiLi4vLi4vbWV0cmljXCI7XG5cbmV4cG9ydCBlbnVtIFVzYWdlVHlwZSB7XG4gIFA1MCA9IFwiUDUwXCIsXG4gIFA3MCA9IFwiUDcwXCIsXG4gIFA5MCA9IFwiUDkwXCIsXG4gIFA5OSA9IFwiUDk5XCIsXG4gIFA5OTkgPSBcIlA5OTlcIixcbiAgUDk5OTkgPSBcIlA5OTk5XCIsXG4gIFAxMDAgPSBcIlAxMDBcIixcbiAgQVZFUkFHRSA9IFwiQXZlcmFnZVwiLFxuICBNQVggPSBcIk1heGltdW1cIixcbn1cblxuZXhwb3J0IGludGVyZmFjZSBVc2FnZVRocmVzaG9sZCBleHRlbmRzIEN1c3RvbUFsYXJtVGhyZXNob2xkIHtcbiAgcmVhZG9ubHkgbWF4VXNhZ2VQZXJjZW50OiBudW1iZXI7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgVXNhZ2VDb3VudFRocmVzaG9sZCBleHRlbmRzIEN1c3RvbUFsYXJtVGhyZXNob2xkIHtcbiAgcmVhZG9ubHkgbWF4VXNhZ2VDb3VudDogbnVtYmVyO1xufVxuXG5leHBvcnQgY2xhc3MgVXNhZ2VBbGFybUZhY3Rvcnkge1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgYWxhcm1GYWN0b3J5OiBBbGFybUZhY3Rvcnk7XG5cbiAgY29uc3RydWN0b3IoYWxhcm1GYWN0b3J5OiBBbGFybUZhY3RvcnkpIHtcbiAgICB0aGlzLmFsYXJtRmFjdG9yeSA9IGFsYXJtRmFjdG9yeTtcbiAgfVxuXG4gIGFkZE1heENwdVVzYWdlUGVyY2VudEFsYXJtKFxuICAgIHBlcmNlbnRNZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQsXG4gICAgcHJvcHM6IFVzYWdlVGhyZXNob2xkLFxuICAgIGRpc2FtYmlndWF0b3I/OiBzdHJpbmdcbiAgKSB7XG4gICAgcmV0dXJuIHRoaXMuYWxhcm1GYWN0b3J5LmFkZEFsYXJtKHBlcmNlbnRNZXRyaWMsIHtcbiAgICAgIHRyZWF0TWlzc2luZ0RhdGE6XG4gICAgICAgIHByb3BzLnRyZWF0TWlzc2luZ0RhdGFPdmVycmlkZSA/PyBUcmVhdE1pc3NpbmdEYXRhLk1JU1NJTkcsXG4gICAgICBjb21wYXJpc29uT3BlcmF0b3I6XG4gICAgICAgIHByb3BzLmNvbXBhcmlzb25PcGVyYXRvck92ZXJyaWRlID8/XG4gICAgICAgIENvbXBhcmlzb25PcGVyYXRvci5HUkVBVEVSX1RIQU5fVEhSRVNIT0xELFxuICAgICAgLi4ucHJvcHMsXG4gICAgICBkaXNhbWJpZ3VhdG9yLFxuICAgICAgdGhyZXNob2xkOiBwcm9wcy5tYXhVc2FnZVBlcmNlbnQsXG4gICAgICBhbGFybU5hbWVTdWZmaXg6IFwiQ1BVLVVzYWdlXCIsXG4gICAgICBhbGFybURlc2NyaXB0aW9uOiBcIlRoZSBDUFUgdXNhZ2UgaXMgdG9vIGhpZ2guXCIsXG4gICAgfSk7XG4gIH1cblxuICBhZGRNYXhNYXN0ZXJDcHVVc2FnZVBlcmNlbnRBbGFybShcbiAgICBwZXJjZW50TWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0LFxuICAgIHByb3BzOiBVc2FnZVRocmVzaG9sZCxcbiAgICBkaXNhbWJpZ3VhdG9yPzogc3RyaW5nXG4gICkge1xuICAgIHJldHVybiB0aGlzLmFsYXJtRmFjdG9yeS5hZGRBbGFybShwZXJjZW50TWV0cmljLCB7XG4gICAgICB0cmVhdE1pc3NpbmdEYXRhOlxuICAgICAgICBwcm9wcy50cmVhdE1pc3NpbmdEYXRhT3ZlcnJpZGUgPz8gVHJlYXRNaXNzaW5nRGF0YS5NSVNTSU5HLFxuICAgICAgY29tcGFyaXNvbk9wZXJhdG9yOlxuICAgICAgICBwcm9wcy5jb21wYXJpc29uT3BlcmF0b3JPdmVycmlkZSA/P1xuICAgICAgICBDb21wYXJpc29uT3BlcmF0b3IuR1JFQVRFUl9USEFOX1RIUkVTSE9MRCxcbiAgICAgIC4uLnByb3BzLFxuICAgICAgZGlzYW1iaWd1YXRvcixcbiAgICAgIHRocmVzaG9sZDogcHJvcHMubWF4VXNhZ2VQZXJjZW50LFxuICAgICAgYWxhcm1OYW1lU3VmZml4OiBcIk1hc3Rlci1DUFUtVXNhZ2VcIixcbiAgICAgIGFsYXJtRGVzY3JpcHRpb246IFwiVGhlIG1hc3RlciBDUFUgdXNhZ2UgaXMgdG9vIGhpZ2guXCIsXG4gICAgfSk7XG4gIH1cblxuICBhZGRNYXhNZW1vcnlVc2FnZVBlcmNlbnRBbGFybShcbiAgICBwZXJjZW50TWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0LFxuICAgIHByb3BzOiBVc2FnZVRocmVzaG9sZCxcbiAgICBkaXNhbWJpZ3VhdG9yPzogc3RyaW5nXG4gICkge1xuICAgIHJldHVybiB0aGlzLmFkZE1lbW9yeVVzYWdlUGVyY2VudEFsYXJtKFxuICAgICAgcGVyY2VudE1ldHJpYyxcbiAgICAgIHByb3BzLFxuICAgICAgVXNhZ2VUeXBlLk1BWCxcbiAgICAgIGRpc2FtYmlndWF0b3JcbiAgICApO1xuICB9XG5cbiAgYWRkTWVtb3J5VXNhZ2VQZXJjZW50QWxhcm0oXG4gICAgcGVyY2VudE1ldHJpYzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydCxcbiAgICBwcm9wczogVXNhZ2VUaHJlc2hvbGQsXG4gICAgdXNhZ2VUeXBlOiBVc2FnZVR5cGUsXG4gICAgZGlzYW1iaWd1YXRvcj86IHN0cmluZ1xuICApIHtcbiAgICBjb25zdCBhbGFybU5hbWVTdWZmaXg6IHN0cmluZyA9XG4gICAgICB1c2FnZVR5cGUgPT09IFVzYWdlVHlwZS5NQVhcbiAgICAgICAgPyBcIk1lbW9yeS1Vc2FnZVwiXG4gICAgICAgIDogYCR7dXNhZ2VUeXBlfS1NZW1vcnktVXNhZ2VgO1xuICAgIHJldHVybiB0aGlzLmFsYXJtRmFjdG9yeS5hZGRBbGFybShwZXJjZW50TWV0cmljLCB7XG4gICAgICB0cmVhdE1pc3NpbmdEYXRhOlxuICAgICAgICBwcm9wcy50cmVhdE1pc3NpbmdEYXRhT3ZlcnJpZGUgPz8gVHJlYXRNaXNzaW5nRGF0YS5NSVNTSU5HLFxuICAgICAgY29tcGFyaXNvbk9wZXJhdG9yOlxuICAgICAgICBwcm9wcy5jb21wYXJpc29uT3BlcmF0b3JPdmVycmlkZSA/P1xuICAgICAgICBDb21wYXJpc29uT3BlcmF0b3IuR1JFQVRFUl9USEFOX1RIUkVTSE9MRCxcbiAgICAgIC4uLnByb3BzLFxuICAgICAgZGlzYW1iaWd1YXRvcixcbiAgICAgIHRocmVzaG9sZDogcHJvcHMubWF4VXNhZ2VQZXJjZW50LFxuICAgICAgYWxhcm1OYW1lU3VmZml4LFxuICAgICAgYWxhcm1EZXNjcmlwdGlvbjogXCJUaGUgbWVtb3J5IHVzYWdlIGlzIHRvbyBoaWdoLlwiLFxuICAgIH0pO1xuICB9XG5cbiAgYWRkTWF4TWFzdGVyTWVtb3J5VXNhZ2VQZXJjZW50QWxhcm0oXG4gICAgcGVyY2VudE1ldHJpYzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydCxcbiAgICBwcm9wczogVXNhZ2VUaHJlc2hvbGQsXG4gICAgZGlzYW1iaWd1YXRvcj86IHN0cmluZ1xuICApIHtcbiAgICByZXR1cm4gdGhpcy5hbGFybUZhY3RvcnkuYWRkQWxhcm0ocGVyY2VudE1ldHJpYywge1xuICAgICAgdHJlYXRNaXNzaW5nRGF0YTpcbiAgICAgICAgcHJvcHMudHJlYXRNaXNzaW5nRGF0YU92ZXJyaWRlID8/IFRyZWF0TWlzc2luZ0RhdGEuTUlTU0lORyxcbiAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjpcbiAgICAgICAgcHJvcHMuY29tcGFyaXNvbk9wZXJhdG9yT3ZlcnJpZGUgPz9cbiAgICAgICAgQ29tcGFyaXNvbk9wZXJhdG9yLkdSRUFURVJfVEhBTl9USFJFU0hPTEQsXG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGRpc2FtYmlndWF0b3IsXG4gICAgICB0aHJlc2hvbGQ6IHByb3BzLm1heFVzYWdlUGVyY2VudCxcbiAgICAgIGFsYXJtTmFtZVN1ZmZpeDogXCJNYXN0ZXItTWVtb3J5LVVzYWdlXCIsXG4gICAgICBhbGFybURlc2NyaXB0aW9uOiBcIlRoZSBtYXN0ZXIgbWVtb3J5IHVzYWdlIGlzIHRvbyBoaWdoLlwiLFxuICAgIH0pO1xuICB9XG5cbiAgYWRkTWF4RGlza1VzYWdlUGVyY2VudEFsYXJtKFxuICAgIHBlcmNlbnRNZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQsXG4gICAgcHJvcHM6IFVzYWdlVGhyZXNob2xkLFxuICAgIGRpc2FtYmlndWF0b3I/OiBzdHJpbmdcbiAgKSB7XG4gICAgcmV0dXJuIHRoaXMuYWxhcm1GYWN0b3J5LmFkZEFsYXJtKHBlcmNlbnRNZXRyaWMsIHtcbiAgICAgIHRyZWF0TWlzc2luZ0RhdGE6XG4gICAgICAgIHByb3BzLnRyZWF0TWlzc2luZ0RhdGFPdmVycmlkZSA/PyBUcmVhdE1pc3NpbmdEYXRhLk1JU1NJTkcsXG4gICAgICBjb21wYXJpc29uT3BlcmF0b3I6XG4gICAgICAgIHByb3BzLmNvbXBhcmlzb25PcGVyYXRvck92ZXJyaWRlID8/XG4gICAgICAgIENvbXBhcmlzb25PcGVyYXRvci5HUkVBVEVSX1RIQU5fVEhSRVNIT0xELFxuICAgICAgLi4ucHJvcHMsXG4gICAgICBkaXNhbWJpZ3VhdG9yLFxuICAgICAgdGhyZXNob2xkOiBwcm9wcy5tYXhVc2FnZVBlcmNlbnQsXG4gICAgICBhbGFybU5hbWVTdWZmaXg6IFwiRGlzay1Vc2FnZVwiLFxuICAgICAgYWxhcm1EZXNjcmlwdGlvbjogXCJUaGUgZGlzayB1c2FnZSBpcyB0b28gaGlnaC5cIixcbiAgICB9KTtcbiAgfVxuXG4gIGFkZE1heEhlYXBNZW1vcnlBZnRlckdDVXNhZ2VQZXJjZW50QWxhcm0oXG4gICAgcGVyY2VudE1ldHJpYzogTWV0cmljV2l0aEFsYXJtU3VwcG9ydCxcbiAgICBwcm9wczogVXNhZ2VUaHJlc2hvbGQsXG4gICAgZGlzYW1iaWd1YXRvcj86IHN0cmluZ1xuICApIHtcbiAgICByZXR1cm4gdGhpcy5hbGFybUZhY3RvcnkuYWRkQWxhcm0ocGVyY2VudE1ldHJpYywge1xuICAgICAgdHJlYXRNaXNzaW5nRGF0YTpcbiAgICAgICAgcHJvcHMudHJlYXRNaXNzaW5nRGF0YU92ZXJyaWRlID8/IFRyZWF0TWlzc2luZ0RhdGEuTUlTU0lORyxcbiAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjpcbiAgICAgICAgcHJvcHMuY29tcGFyaXNvbk9wZXJhdG9yT3ZlcnJpZGUgPz9cbiAgICAgICAgQ29tcGFyaXNvbk9wZXJhdG9yLkdSRUFURVJfVEhBTl9USFJFU0hPTEQsXG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGRpc2FtYmlndWF0b3IsXG4gICAgICB0aHJlc2hvbGQ6IHByb3BzLm1heFVzYWdlUGVyY2VudCxcbiAgICAgIGFsYXJtTmFtZVN1ZmZpeDogXCJIZWFwTWVtb3J5QWZ0ZXJHQy1Vc2FnZVwiLFxuICAgICAgYWxhcm1EZXNjcmlwdGlvbjogXCJUaGUgaGVhcCBtZW1vcnkgYWZ0ZXIgR0MgdXNhZ2UgaXMgdG9vIGhpZ2guXCIsXG4gICAgfSk7XG4gIH1cblxuICBhZGRNYXhGaWxlRGVzY3JpcHRvclBlcmNlbnRBbGFybShcbiAgICBwZXJjZW50TWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0LFxuICAgIHByb3BzOiBVc2FnZVRocmVzaG9sZCxcbiAgICBkaXNhbWJpZ3VhdG9yPzogc3RyaW5nXG4gICkge1xuICAgIHJldHVybiB0aGlzLmFsYXJtRmFjdG9yeS5hZGRBbGFybShwZXJjZW50TWV0cmljLCB7XG4gICAgICB0cmVhdE1pc3NpbmdEYXRhOlxuICAgICAgICBwcm9wcy50cmVhdE1pc3NpbmdEYXRhT3ZlcnJpZGUgPz8gVHJlYXRNaXNzaW5nRGF0YS5NSVNTSU5HLFxuICAgICAgY29tcGFyaXNvbk9wZXJhdG9yOlxuICAgICAgICBwcm9wcy5jb21wYXJpc29uT3BlcmF0b3JPdmVycmlkZSA/P1xuICAgICAgICBDb21wYXJpc29uT3BlcmF0b3IuR1JFQVRFUl9USEFOX1RIUkVTSE9MRCxcbiAgICAgIC4uLnByb3BzLFxuICAgICAgZGlzYW1iaWd1YXRvcixcbiAgICAgIHRocmVzaG9sZDogcHJvcHMubWF4VXNhZ2VQZXJjZW50LFxuICAgICAgYWxhcm1OYW1lU3VmZml4OiBcIkZpbGUtRGVzY3JpcHRvci1Vc2FnZVwiLFxuICAgICAgYWxhcm1EZXNjcmlwdGlvbjogXCJUaGUgZmlsZSBkZXNjcmlwdG9yIHVzYWdlIGlzIHRvbyBoaWdoLlwiLFxuICAgIH0pO1xuICB9XG5cbiAgYWRkTWF4VGhyZWFkQ291bnRVc2FnZUFsYXJtKFxuICAgIHBlcmNlbnRNZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQsXG4gICAgcHJvcHM6IFVzYWdlQ291bnRUaHJlc2hvbGQsXG4gICAgZGlzYW1iaWd1YXRvcj86IHN0cmluZ1xuICApIHtcbiAgICByZXR1cm4gdGhpcy5hbGFybUZhY3RvcnkuYWRkQWxhcm0ocGVyY2VudE1ldHJpYywge1xuICAgICAgdHJlYXRNaXNzaW5nRGF0YTpcbiAgICAgICAgcHJvcHMudHJlYXRNaXNzaW5nRGF0YU92ZXJyaWRlID8/IFRyZWF0TWlzc2luZ0RhdGEuTUlTU0lORyxcbiAgICAgIGNvbXBhcmlzb25PcGVyYXRvcjpcbiAgICAgICAgcHJvcHMuY29tcGFyaXNvbk9wZXJhdG9yT3ZlcnJpZGUgPz9cbiAgICAgICAgQ29tcGFyaXNvbk9wZXJhdG9yLkdSRUFURVJfVEhBTl9USFJFU0hPTEQsXG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGRpc2FtYmlndWF0b3IsXG4gICAgICB0aHJlc2hvbGQ6IHByb3BzLm1heFVzYWdlQ291bnQsXG4gICAgICBhbGFybU5hbWVTdWZmaXg6IFwiVGhyZWFkLUNvdW50XCIsXG4gICAgICBhbGFybURlc2NyaXB0aW9uOiBcIlRoZSB0aHJlYWQgY291bnQgaXMgdG9vIGhpZ2guXCIsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==