"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.recommendedWidgetWidth = exports.DefaultLogWidgetHeight = exports.DefaultAlarmWidgetHeight = exports.DefaultAlarmWidgetWidth = exports.DefaultSummaryWidgetHeight = exports.DefaultTwoLinerGraphWidgetHalfHeight = exports.DefaultTwoLinerGraphWidgetHeight = exports.DefaultGraphWidgetHeight = exports.ThreeQuartersWidth = exports.TwoThirdsWidth = exports.SixthWidth = exports.HalfQuarterWidth = exports.QuarterWidth = exports.ThirdWidth = exports.HalfWidth = exports.FullWidth = void 0;
exports.FullWidth = 24;
exports.HalfWidth = exports.FullWidth / 2;
exports.ThirdWidth = exports.FullWidth / 3;
exports.QuarterWidth = exports.FullWidth / 4;
exports.HalfQuarterWidth = exports.QuarterWidth / 2;
exports.SixthWidth = exports.FullWidth / 6;
exports.TwoThirdsWidth = 2 * exports.ThirdWidth;
exports.ThreeQuartersWidth = 3 * exports.QuarterWidth;
// Widget Heights
exports.DefaultGraphWidgetHeight = 5;
exports.DefaultTwoLinerGraphWidgetHeight = 6;
exports.DefaultTwoLinerGraphWidgetHalfHeight = 3;
exports.DefaultSummaryWidgetHeight = 6;
exports.DefaultAlarmWidgetWidth = 6;
exports.DefaultAlarmWidgetHeight = 4;
exports.DefaultLogWidgetHeight = 7;
/**
 * Suggests the best widget width, given the total number of widgets.
 * The main point is to make widgets as wide as possible, while saving vertical space and minimizing number of gaps.
 * @param numTotalWidgets total number of widgets to be placed
 */
function recommendedWidgetWidth(numTotalWidgets) {
    function numRowsTaken(numItems, itemSize) {
        return Math.ceil((numItems * itemSize) / exports.FullWidth);
    }
    const numItemsFixed = Math.max(1, numTotalWidgets);
    const widths = [exports.QuarterWidth, exports.ThirdWidth, exports.HalfWidth, exports.FullWidth];
    let i = 0;
    while (i < widths.length - 1 &&
        numRowsTaken(numItemsFixed, widths[i + 1]) ===
            numRowsTaken(numItemsFixed, widths[i])) {
        i++;
    }
    return widths[i];
}
exports.recommendedWidgetWidth = recommendedWidgetWidth;
//# sourceMappingURL=data:application/json;base64,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