import { GraphWidget, GraphWidgetProps } from "aws-cdk-lib/aws-cloudwatch";
export declare enum GraphWidgetType {
    LINE = "Line",
    STACKED_AREA = "StackedArea",
    PIE = "Pie",
    BAR = "Bar"
}
/**
 * Creates a graph widget of the desired type.
 * @param type graph type (e.g. Pie or Bar)
 * @param props graph widget properties
 */
export declare function createGraphWidget(type: GraphWidgetType, props: GraphWidgetProps): GraphWidget;
