"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGraphWidget = exports.GraphWidgetType = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
var GraphWidgetType;
(function (GraphWidgetType) {
    GraphWidgetType["LINE"] = "Line";
    GraphWidgetType["STACKED_AREA"] = "StackedArea";
    GraphWidgetType["PIE"] = "Pie";
    GraphWidgetType["BAR"] = "Bar";
})(GraphWidgetType = exports.GraphWidgetType || (exports.GraphWidgetType = {}));
/**
 * Creates a graph widget of the desired type.
 * @param type graph type (e.g. Pie or Bar)
 * @param props graph widget properties
 */
function createGraphWidget(type, props) {
    switch (type) {
        case "Line":
            return new aws_cloudwatch_1.GraphWidget(props);
        case "Bar":
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                view: aws_cloudwatch_1.GraphWidgetView.BAR,
            });
        case "Pie":
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                view: aws_cloudwatch_1.GraphWidgetView.PIE,
            });
        case "StackedArea":
            return new aws_cloudwatch_1.GraphWidget({
                ...props,
                stacked: true,
            });
        default:
            throw new Error("Unsupported graph type: " + type);
    }
}
exports.createGraphWidget = createGraphWidget;
//# sourceMappingURL=data:application/json;base64,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