"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultDashboardFactory = exports.DashboardRenderingPreference = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const constructs_1 = require("constructs");
const BitmapDashboard_1 = require("./BitmapDashboard");
const DashboardWithBitmapCopy_1 = require("./DashboardWithBitmapCopy");
/**
 * Preferred way of rendering the widgets.
 */
var DashboardRenderingPreference;
(function (DashboardRenderingPreference) {
    /**
     * create standard set of dashboards with interactive widgets only
     */
    DashboardRenderingPreference[DashboardRenderingPreference["INTERACTIVE_ONLY"] = 0] = "INTERACTIVE_ONLY";
    /**
     * create standard set of dashboards with bitmap widgets only
     */
    DashboardRenderingPreference[DashboardRenderingPreference["BITMAP_ONLY"] = 1] = "BITMAP_ONLY";
    /**
     * create a two sets of dashboards: standard set (interactive) and a copy (bitmap)
     */
    DashboardRenderingPreference[DashboardRenderingPreference["INTERACTIVE_AND_BITMAP"] = 2] = "INTERACTIVE_AND_BITMAP";
})(DashboardRenderingPreference = exports.DashboardRenderingPreference || (exports.DashboardRenderingPreference = {}));
class DefaultDashboardFactory extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        const detailStart = "-" + ((_b = props.detailDashboardRange) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Duration.hours(8)).toIsoString();
        const summaryStart = "-" + ((_c = props.summaryDashboardRange) !== null && _c !== void 0 ? _c : aws_cdk_lib_1.Duration.days(14)).toIsoString();
        let anyDashboardCreated = false;
        if (props.createDashboard) {
            anyDashboardCreated = true;
            this.dashboard = this.createDashboard(props.renderingPreference, "Dashboard", {
                dashboardName: props.dashboardNamePrefix,
                start: detailStart,
                periodOverride: (_d = props.detailDashboardPeriodOverride) !== null && _d !== void 0 ? _d : aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        if (props.createSummaryDashboard) {
            anyDashboardCreated = true;
            this.summaryDashboard = this.createDashboard(props.renderingPreference, "SummaryDashboard", {
                dashboardName: `${props.dashboardNamePrefix}-Summary`,
                start: summaryStart,
                periodOverride: (_e = props.summaryDashboardPeriodOverride) !== null && _e !== void 0 ? _e : aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        if (props.createAlarmDashboard) {
            anyDashboardCreated = true;
            this.alarmDashboard = this.createDashboard(props.renderingPreference, "AlarmDashboard", {
                dashboardName: `${props.dashboardNamePrefix}-Alarms`,
                start: detailStart,
                periodOverride: (_f = props.detailDashboardPeriodOverride) !== null && _f !== void 0 ? _f : aws_cloudwatch_1.PeriodOverride.INHERIT,
            });
        }
        this.anyDashboardCreated = anyDashboardCreated;
    }
    createDashboard(renderingPreference, id, props) {
        switch (renderingPreference) {
            case DashboardRenderingPreference.INTERACTIVE_ONLY:
                return new aws_cloudwatch_1.Dashboard(this, id, props);
            case DashboardRenderingPreference.BITMAP_ONLY:
                return new BitmapDashboard_1.BitmapDashboard(this, id, props);
            case DashboardRenderingPreference.INTERACTIVE_AND_BITMAP:
                return new DashboardWithBitmapCopy_1.DashboardWithBitmapCopy(this, id, props);
        }
    }
    addSegment(props) {
        var _b, _c, _d, _e, _f, _g;
        if (((_c = (_b = props.overrideProps) === null || _b === void 0 ? void 0 : _b.addToDetailDashboard) !== null && _c !== void 0 ? _c : true) && this.dashboard) {
            this.dashboard.addWidgets(...props.segment.widgets());
        }
        if (((_e = (_d = props.overrideProps) === null || _d === void 0 ? void 0 : _d.addToSummaryDashboard) !== null && _e !== void 0 ? _e : true) &&
            this.summaryDashboard) {
            this.summaryDashboard.addWidgets(...props.segment.summaryWidgets());
        }
        if (((_g = (_f = props.overrideProps) === null || _f === void 0 ? void 0 : _f.addToAlarmDashboard) !== null && _g !== void 0 ? _g : true) &&
            this.alarmDashboard) {
            this.alarmDashboard.addWidgets(...props.segment.alarmWidgets());
        }
    }
    createdDashboard() {
        return this.dashboard;
    }
    createdSummaryDashboard() {
        return this.summaryDashboard;
    }
    createdAlarmDashboard() {
        return this.alarmDashboard;
    }
}
exports.DefaultDashboardFactory = DefaultDashboardFactory;
_a = JSII_RTTI_SYMBOL_1;
DefaultDashboardFactory[_a] = { fqn: "cdk-monitoring-constructs.DefaultDashboardFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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