"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitoringNamingStrategy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Utility class to unify approach to naming monitoring sections.
 * @see https://docs.aws.amazon.com/cdk/latest/guide/tokens.html#tokens_lazy
 */
class MonitoringNamingStrategy {
    constructor(input) {
        this.input = input;
    }
    resolveAlarmFriendlyName() {
        var _b;
        return (_b = this.input.alarmFriendlyName) !== null && _b !== void 0 ? _b : this.getFallbackAlarmFriendlyName();
    }
    resolveHumanReadableName() {
        var _b;
        return (_b = this.input.humanReadableName) !== null && _b !== void 0 ? _b : this.getFallbackHumanReadableName();
    }
    static isAlarmFriendly(str) {
        // we do not know the exact pattern yet, but this is a safe approximation
        // also, tokens are not allowed in alarm names
        return str && !aws_cdk_lib_1.Token.isUnresolved(str) && /^[a-zA-Z0-9\-_]+$/.test(str);
    }
    getFallbackAlarmFriendlyName() {
        if (this.input.fallbackConstructName) {
            if (MonitoringNamingStrategy.isAlarmFriendly(this.input.fallbackConstructName)) {
                return this.input.fallbackConstructName;
            }
        }
        if (this.input.namedConstruct) {
            const node = this.input.namedConstruct.node;
            if (MonitoringNamingStrategy.isAlarmFriendly(node.id)) {
                // scope-unique ID
                return node.id;
            }
        }
        throw new Error("Insufficient information provided for naming the alarms and/or monitoring section: " +
            "Please provide alarmFriendlyName, humanReadableName, or namedConstruct as a fallback");
    }
    getFallbackHumanReadableName() {
        return aws_cdk_lib_1.Lazy.uncachedString({
            produce: (context) => {
                const resolvedName = context.resolve(this.input.fallbackConstructName);
                if (typeof resolvedName === "string" &&
                    MonitoringNamingStrategy.isNonBlank(resolvedName)) {
                    return resolvedName;
                }
                if (this.input.namedConstruct) {
                    const node = this.input.namedConstruct.node;
                    if (MonitoringNamingStrategy.isNonBlank(node.id)) {
                        // scope-unique ID
                        return node.id;
                    }
                }
                return this.resolveAlarmFriendlyName();
            },
        });
    }
    static isNonBlank(str) {
        return str && str.trim().length > 0;
    }
}
exports.MonitoringNamingStrategy = MonitoringNamingStrategy;
_a = JSII_RTTI_SYMBOL_1;
MonitoringNamingStrategy[_a] = { fqn: "cdk-monitoring-constructs.MonitoringNamingStrategy", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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