"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlarmMatrixWidget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const widget_1 = require("../../common/widget");
const AlarmsPerRow = 6;
const MinHeight = 2;
const MaxHeight = 8;
/**
 * Wrapper of Alarm Status Widget which auto-calcultes height based on the number of alarms.
 * Always takes the maximum width.
 */
class AlarmMatrixWidget extends aws_cloudwatch_1.AlarmStatusWidget {
    constructor(props) {
        var _b;
        super({
            alarms: props.alarms,
            title: props.title,
            width: widget_1.FullWidth,
            height: (_b = props.height) !== null && _b !== void 0 ? _b : AlarmMatrixWidget.getRecommendedHeight(props.alarms.length),
        });
    }
    static getRecommendedHeight(numAlarms) {
        const rows = Math.ceil(numAlarms / AlarmsPerRow);
        if (rows < MinHeight) {
            return MinHeight;
        }
        if (rows > MaxHeight) {
            return MaxHeight;
        }
        return rows;
    }
}
exports.AlarmMatrixWidget = AlarmMatrixWidget;
_a = JSII_RTTI_SYMBOL_1;
AlarmMatrixWidget[_a] = { fqn: "cdk-monitoring-constructs.AlarmMatrixWidget", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQWxhcm1NYXRyaXhXaWRnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJBbGFybU1hdHJpeFdpZGdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLCtEQUF1RTtBQUV2RSxnREFBZ0Q7QUFFaEQsTUFBTSxZQUFZLEdBQUcsQ0FBQyxDQUFDO0FBQ3ZCLE1BQU0sU0FBUyxHQUFHLENBQUMsQ0FBQztBQUNwQixNQUFNLFNBQVMsR0FBRyxDQUFDLENBQUM7QUFtQnBCOzs7R0FHRztBQUNILE1BQWEsaUJBQWtCLFNBQVEsa0NBQWlCO0lBQ3RELFlBQVksS0FBNkI7O1FBQ3ZDLEtBQUssQ0FBQztZQUNKLE1BQU0sRUFBRSxLQUFLLENBQUMsTUFBTTtZQUNwQixLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsS0FBSyxFQUFFLGtCQUFTO1lBQ2hCLE1BQU0sUUFDSixLQUFLLENBQUMsTUFBTSxtQ0FDWixpQkFBaUIsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQztTQUM5RCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sTUFBTSxDQUFDLG9CQUFvQixDQUFDLFNBQWlCO1FBQ25ELE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxHQUFHLFlBQVksQ0FBQyxDQUFDO1FBQ2pELElBQUksSUFBSSxHQUFHLFNBQVMsRUFBRTtZQUNwQixPQUFPLFNBQVMsQ0FBQztTQUNsQjtRQUNELElBQUksSUFBSSxHQUFHLFNBQVMsRUFBRTtZQUNwQixPQUFPLFNBQVMsQ0FBQztTQUNsQjtRQUNELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7QUFyQkgsOENBc0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWxhcm1TdGF0dXNXaWRnZXQsIElBbGFybSB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuXG5pbXBvcnQgeyBGdWxsV2lkdGggfSBmcm9tIFwiLi4vLi4vY29tbW9uL3dpZGdldFwiO1xuXG5jb25zdCBBbGFybXNQZXJSb3cgPSA2O1xuY29uc3QgTWluSGVpZ2h0ID0gMjtcbmNvbnN0IE1heEhlaWdodCA9IDg7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQWxhcm1NYXRyaXhXaWRnZXRQcm9wcyB7XG4gIC8qKlxuICAgKiB3aWRnZXQgdGl0bGVcbiAgICogQGRlZmF1bHQgbm8gdGl0bGVcbiAgICovXG4gIHJlYWRvbmx5IHRpdGxlPzogc3RyaW5nO1xuICAvKipcbiAgICogZGVzaXJlZCBoZWlnaHRcbiAgICogQGRlZmF1bHQgYXV0byBjYWxjdWxhdGVkIGJhc2VkIG9uIGFsYXJtIG51bWJlciAoMyB0byA4KVxuICAgKi9cbiAgcmVhZG9ubHkgaGVpZ2h0PzogbnVtYmVyO1xuICAvKipcbiAgICogbGlzdCBvZiBhbGFybXMgdG8gc2hvd1xuICAgKi9cbiAgcmVhZG9ubHkgYWxhcm1zOiBJQWxhcm1bXTtcbn1cblxuLyoqXG4gKiBXcmFwcGVyIG9mIEFsYXJtIFN0YXR1cyBXaWRnZXQgd2hpY2ggYXV0by1jYWxjdWx0ZXMgaGVpZ2h0IGJhc2VkIG9uIHRoZSBudW1iZXIgb2YgYWxhcm1zLlxuICogQWx3YXlzIHRha2VzIHRoZSBtYXhpbXVtIHdpZHRoLlxuICovXG5leHBvcnQgY2xhc3MgQWxhcm1NYXRyaXhXaWRnZXQgZXh0ZW5kcyBBbGFybVN0YXR1c1dpZGdldCB7XG4gIGNvbnN0cnVjdG9yKHByb3BzOiBBbGFybU1hdHJpeFdpZGdldFByb3BzKSB7XG4gICAgc3VwZXIoe1xuICAgICAgYWxhcm1zOiBwcm9wcy5hbGFybXMsXG4gICAgICB0aXRsZTogcHJvcHMudGl0bGUsXG4gICAgICB3aWR0aDogRnVsbFdpZHRoLFxuICAgICAgaGVpZ2h0OlxuICAgICAgICBwcm9wcy5oZWlnaHQgPz9cbiAgICAgICAgQWxhcm1NYXRyaXhXaWRnZXQuZ2V0UmVjb21tZW5kZWRIZWlnaHQocHJvcHMuYWxhcm1zLmxlbmd0aCksXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIHN0YXRpYyBnZXRSZWNvbW1lbmRlZEhlaWdodChudW1BbGFybXM6IG51bWJlcikge1xuICAgIGNvbnN0IHJvd3MgPSBNYXRoLmNlaWwobnVtQWxhcm1zIC8gQWxhcm1zUGVyUm93KTtcbiAgICBpZiAocm93cyA8IE1pbkhlaWdodCkge1xuICAgICAgcmV0dXJuIE1pbkhlaWdodDtcbiAgICB9XG4gICAgaWYgKHJvd3MgPiBNYXhIZWlnaHQpIHtcbiAgICAgIHJldHVybiBNYXhIZWlnaHQ7XG4gICAgfVxuICAgIHJldHVybiByb3dzO1xuICB9XG59XG4iXX0=