"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitmapWidgetRenderingSupport = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const CustomWidget_1 = require("./CustomWidget");
/**
 * Support for rendering bitmap widgets on the server side.
 * It is a custom widget lambda with some additional roles and helper methods.
 */
class BitmapWidgetRenderingSupport extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.handler = new aws_lambda_1.Function(this, "Lambda", {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "..", "..", "..", "assets", "BitmapWidgetRenderingSupport")),
            description: "Custom Widget Render for Bitmap Widgets (MonitoringCDKConstructs)",
            handler: "index.handler",
            memorySize: 128,
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            logRetention: aws_logs_1.RetentionDays.ONE_DAY,
        });
        this.handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            actions: ["cloudwatch:GetMetricWidgetImage"],
            effect: aws_iam_1.Effect.ALLOW,
            resources: ["*"],
        }));
        aws_cdk_lib_1.Tags.of(this.handler).add("cw-custom-widget", "describe:readOnly");
    }
    asBitmap(widget) {
        const props = this.getWidgetProperties(widget);
        // remove the title from the graph and remember it
        const { title, ...graph } = props;
        return new CustomWidget_1.CustomWidget({
            // move the original title here
            title,
            width: widget.width,
            height: widget.height,
            // empty the inner title since we already have it on the whole widget
            handlerParams: { graph: { ...graph, title: " " } },
            handler: this.handler,
            updateOnRefresh: true,
            updateOnResize: true,
            updateOnTimeRangeChange: true,
        });
    }
    getWidgetProperties(widget) {
        const graphs = widget.toJson();
        if (graphs.length != 1) {
            throw new Error("Number of objects in the widget definition must be exactly one.");
        }
        const graph = graphs[0];
        if (!graph.properties) {
            throw new Error("No graph properties: " + graph);
        }
        return graph.properties;
    }
}
exports.BitmapWidgetRenderingSupport = BitmapWidgetRenderingSupport;
_a = JSII_RTTI_SYMBOL_1;
BitmapWidgetRenderingSupport[_a] = { fqn: "cdk-monitoring-constructs.BitmapWidgetRenderingSupport", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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