"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomWidget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
/**
 * A dashboard widget that can be customized using a Lambda.
 */
class CustomWidget extends aws_cloudwatch_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
    }
    toJson() {
        var _b, _c, _d;
        return [
            {
                type: "custom",
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    title: this.props.title,
                    endpoint: this.props.handler.functionArn,
                    params: this.props.handlerParams || {},
                    updateOn: {
                        refresh: (_b = this.props.updateOnRefresh) !== null && _b !== void 0 ? _b : true,
                        resize: (_c = this.props.updateOnResize) !== null && _c !== void 0 ? _c : true,
                        timeRange: (_d = this.props.updateOnTimeRangeChange) !== null && _d !== void 0 ? _d : true,
                    },
                },
            },
        ];
    }
}
exports.CustomWidget = CustomWidget;
_a = JSII_RTTI_SYMBOL_1;
CustomWidget[_a] = { fqn: "cdk-monitoring-constructs.CustomWidget", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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