"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderWidget = exports.HeaderLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const widget_1 = require("../../common/widget");
var HeaderLevel;
(function (HeaderLevel) {
    HeaderLevel[HeaderLevel["LARGE"] = 0] = "LARGE";
    HeaderLevel[HeaderLevel["MEDIUM"] = 1] = "MEDIUM";
    HeaderLevel[HeaderLevel["SMALL"] = 2] = "SMALL";
})(HeaderLevel = exports.HeaderLevel || (exports.HeaderLevel = {}));
class HeaderWidget extends aws_cloudwatch_1.TextWidget {
    constructor(text, level) {
        super({
            width: widget_1.FullWidth,
            height: 1,
            markdown: HeaderWidget.toMarkdown(text, level !== null && level !== void 0 ? level : HeaderLevel.LARGE),
        });
    }
    static toMarkdown(text, level) {
        return "#".repeat(level + 1) + " " + text;
    }
}
exports.HeaderWidget = HeaderWidget;
_a = JSII_RTTI_SYMBOL_1;
HeaderWidget[_a] = { fqn: "cdk-monitoring-constructs.HeaderWidget", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiSGVhZGVyV2lkZ2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiSGVhZGVyV2lkZ2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBQXdEO0FBRXhELGdEQUFnRDtBQUVoRCxJQUFZLFdBSVg7QUFKRCxXQUFZLFdBQVc7SUFDckIsK0NBQUssQ0FBQTtJQUNMLGlEQUFNLENBQUE7SUFDTiwrQ0FBSyxDQUFBO0FBQ1AsQ0FBQyxFQUpXLFdBQVcsR0FBWCxtQkFBVyxLQUFYLG1CQUFXLFFBSXRCO0FBRUQsTUFBYSxZQUFhLFNBQVEsMkJBQVU7SUFDMUMsWUFBWSxJQUFZLEVBQUUsS0FBbUI7UUFDM0MsS0FBSyxDQUFDO1lBQ0osS0FBSyxFQUFFLGtCQUFTO1lBQ2hCLE1BQU0sRUFBRSxDQUFDO1lBQ1QsUUFBUSxFQUFFLFlBQVksQ0FBQyxVQUFVLENBQUMsSUFBSSxFQUFFLEtBQUssYUFBTCxLQUFLLGNBQUwsS0FBSyxHQUFJLFdBQVcsQ0FBQyxLQUFLLENBQUM7U0FDcEUsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBWSxFQUFFLEtBQWtCO1FBQ3hELE9BQU8sR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLEdBQUcsR0FBRyxHQUFHLElBQUksQ0FBQztJQUM1QyxDQUFDOztBQVhILG9DQVlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVGV4dFdpZGdldCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuXG5pbXBvcnQgeyBGdWxsV2lkdGggfSBmcm9tIFwiLi4vLi4vY29tbW9uL3dpZGdldFwiO1xuXG5leHBvcnQgZW51bSBIZWFkZXJMZXZlbCB7XG4gIExBUkdFLFxuICBNRURJVU0sXG4gIFNNQUxMLFxufVxuXG5leHBvcnQgY2xhc3MgSGVhZGVyV2lkZ2V0IGV4dGVuZHMgVGV4dFdpZGdldCB7XG4gIGNvbnN0cnVjdG9yKHRleHQ6IHN0cmluZywgbGV2ZWw/OiBIZWFkZXJMZXZlbCkge1xuICAgIHN1cGVyKHtcbiAgICAgIHdpZHRoOiBGdWxsV2lkdGgsXG4gICAgICBoZWlnaHQ6IDEsXG4gICAgICBtYXJrZG93bjogSGVhZGVyV2lkZ2V0LnRvTWFya2Rvd24odGV4dCwgbGV2ZWwgPz8gSGVhZGVyTGV2ZWwuTEFSR0UpLFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBzdGF0aWMgdG9NYXJrZG93bih0ZXh0OiBzdHJpbmcsIGxldmVsOiBIZWFkZXJMZXZlbCkge1xuICAgIHJldHVybiBcIiNcIi5yZXBlYXQobGV2ZWwgKyAxKSArIFwiIFwiICsgdGV4dDtcbiAgfVxufVxuIl19