"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitoringAspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigwv2 = require("@aws-cdk/aws-apigatewayv2-alpha");
const appsync = require("@aws-cdk/aws-appsync-alpha");
const redshift = require("@aws-cdk/aws-redshift-alpha");
const synthetics = require("@aws-cdk/aws-synthetics-alpha");
const apigw = require("aws-cdk-lib/aws-apigateway");
const autoscaling = require("aws-cdk-lib/aws-autoscaling");
const acm = require("aws-cdk-lib/aws-certificatemanager");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const codebuild = require("aws-cdk-lib/aws-codebuild");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const elasticsearch = require("aws-cdk-lib/aws-elasticsearch");
const glue = require("aws-cdk-lib/aws-glue");
const kinesis = require("aws-cdk-lib/aws-kinesis");
const kinesisanalytics = require("aws-cdk-lib/aws-kinesisanalytics");
const kinesisfirehose = require("aws-cdk-lib/aws-kinesisfirehose");
const lambda = require("aws-cdk-lib/aws-lambda");
const opensearch = require("aws-cdk-lib/aws-opensearchservice");
const rds = require("aws-cdk-lib/aws-rds");
const s3 = require("aws-cdk-lib/aws-s3");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
const sns = require("aws-cdk-lib/aws-sns");
const sqs = require("aws-cdk-lib/aws-sqs");
const stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
const wafv2 = require("aws-cdk-lib/aws-wafv2");
const monitoring_1 = require("../monitoring");
/**
 * A CDK aspect that adds support for monitoring all resources within scope.
 */
class MonitoringAspect {
    constructor(monitoringFacade, props = {}) {
        this.monitoringFacade = monitoringFacade;
        this.props = props;
        /**
         * Whether or not we've added a monitoring to the scope for node independent monitorings.
         */
        this.addedNodeIndependentMonitoringToScope = false;
    }
    visit(node) {
        this.monitorAcm(node);
        this.monitorApiGateway(node);
        this.monitorApiGatewayV2(node);
        this.monitorAppSync(node);
        this.monitorAutoScalingGroup(node);
        this.monitorCloudFront(node);
        this.monitorCodeBuild(node);
        this.monitorDynamoDb(node);
        this.monitorGlue(node);
        this.monitorKinesisAnalytics(node);
        this.monitorKinesisDataStream(node);
        this.monitorKinesisFirehose(node);
        this.monitorLambda(node);
        this.monitorOpenSearch(node);
        this.monitorRds(node);
        this.monitorRedshift(node);
        this.monitorS3(node);
        this.monitorSecretsManager(node);
        this.monitorSns(node);
        this.monitorSqs(node);
        this.monitorStepFunctions(node);
        this.monitorSyntheticsCanaries(node);
        this.monitorWebApplicationFirewallV2Acls(node);
        if (!this.addedNodeIndependentMonitoringToScope) {
            this.addedNodeIndependentMonitoringToScope = true;
            this.monitorEc2();
            this.monitorBilling();
            this.monitorElasticCache();
        }
    }
    getMonitoringDetails(aspectOptions) {
        var _b;
        const isEnabled = (_b = aspectOptions === null || aspectOptions === void 0 ? void 0 : aspectOptions.enabled) !== null && _b !== void 0 ? _b : true;
        const props = aspectOptions === null || aspectOptions === void 0 ? void 0 : aspectOptions.props;
        return [isEnabled, props];
    }
    monitorAcm(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.acm);
        if (isEnabled && node instanceof acm.Certificate) {
            this.monitoringFacade.monitorCertificate({
                certificate: node,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorApiGateway(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.apiGateway);
        if (isEnabled && node instanceof apigw.RestApi) {
            this.monitoringFacade.monitorApiGateway({
                api: node,
                ...props,
            });
        }
    }
    monitorApiGatewayV2(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.apiGatewayV2);
        if (isEnabled && node instanceof apigwv2.HttpApi) {
            this.monitoringFacade.monitorApiGatewayV2HttpApi({
                api: node,
                ...props,
            });
        }
    }
    monitorAppSync(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.appSync);
        if (isEnabled && node instanceof appsync.GraphqlApi) {
            this.monitoringFacade.monitorAppSyncApi({
                api: node,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorAutoScalingGroup(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.autoScalingGroup);
        if (isEnabled && node instanceof autoscaling.AutoScalingGroup) {
            this.monitoringFacade.monitorAutoScalingGroup({
                autoScalingGroup: node,
                ...props,
            });
        }
    }
    monitorBilling() {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.billing);
        if (isEnabled) {
            this.monitoringFacade.monitorBilling({
                ...props,
                alarmFriendlyName: "Billing",
            });
        }
    }
    monitorCloudFront(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.cloudFront);
        if (isEnabled && node instanceof cloudfront.Distribution) {
            this.monitoringFacade.monitorCloudFrontDistribution({
                distribution: node,
                ...props,
            });
        }
    }
    monitorCodeBuild(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.codeBuild);
        if (isEnabled && node instanceof codebuild.Project) {
            this.monitoringFacade.monitorCodeBuildProject({
                project: node,
                ...props,
            });
        }
    }
    monitorDynamoDb(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.dynamoDB);
        if (isEnabled && node instanceof dynamodb.Table) {
            this.monitoringFacade.monitorDynamoTable({
                table: node,
                ...props,
            });
        }
    }
    monitorEc2() {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.ec2);
        if (isEnabled) {
            this.monitoringFacade.monitorEC2Instances({
                ...props,
            });
        }
    }
    monitorElasticCache() {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.elasticCache);
        if (isEnabled) {
            this.monitoringFacade.monitorElastiCacheCluster({
                clusterType: monitoring_1.ElastiCacheClusterType.MEMCACHED,
                ...props,
            });
            this.monitoringFacade.monitorElastiCacheCluster({
                clusterType: monitoring_1.ElastiCacheClusterType.REDIS,
                ...props,
            });
        }
    }
    monitorGlue(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.glue);
        if (isEnabled && node instanceof glue.CfnJob) {
            this.monitoringFacade.monitorGlueJob({
                jobName: node.name,
                ...props,
            });
        }
    }
    monitorKinesisAnalytics(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.kinesisDataAnalytics);
        if (isEnabled && node instanceof kinesisanalytics.CfnApplication) {
            this.monitoringFacade.monitorKinesisDataAnalytics({
                application: node.applicationName,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorKinesisDataStream(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.kinesisDataStream);
        if (isEnabled && node instanceof kinesis.CfnStream) {
            this.monitoringFacade.monitorKinesisDataStream({
                streamName: node.name,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorKinesisFirehose(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.kinesisFirehose);
        if (isEnabled && node instanceof kinesisfirehose.CfnDeliveryStream) {
            this.monitoringFacade.monitorKinesisFirehose({
                deliveryStreamName: node.deliveryStreamName,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorLambda(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.lambda);
        if (isEnabled && node instanceof lambda.Function) {
            this.monitoringFacade.monitorLambdaFunction({
                lambdaFunction: node,
                ...props,
            });
        }
    }
    monitorOpenSearch(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.openSearch);
        if (isEnabled &&
            (node instanceof elasticsearch.Domain ||
                node instanceof elasticsearch.CfnDomain ||
                node instanceof opensearch.Domain ||
                node instanceof opensearch.CfnDomain)) {
            this.monitoringFacade.monitorOpenSearchCluster({
                domain: node,
                ...props,
            });
        }
    }
    monitorRds(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.rds);
        if (isEnabled && node instanceof rds.DatabaseCluster) {
            this.monitoringFacade.monitorRdsCluster({
                clusterIdentifier: node.clusterIdentifier,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorRedshift(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.redshift);
        if (isEnabled && node instanceof redshift.Cluster) {
            this.monitoringFacade.monitorRedshiftCluster({
                clusterIdentifier: node.clusterName,
                alarmFriendlyName: node.node.path,
                ...props,
            });
        }
    }
    monitorS3(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.s3);
        if (isEnabled && node instanceof s3.Bucket) {
            this.monitoringFacade.monitorS3Bucket({
                bucket: node,
                ...props,
            });
        }
    }
    monitorSecretsManager(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.secretsManager);
        if (isEnabled && node instanceof secretsmanager.Secret) {
            this.monitoringFacade.monitorSecretsManagerSecret({
                secret: node,
                ...props,
            });
        }
    }
    monitorSns(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.sns);
        if (isEnabled && node instanceof sns.Topic) {
            this.monitoringFacade.monitorSnsTopic({
                topic: node,
                ...props,
            });
        }
    }
    monitorSqs(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.sqs);
        if (isEnabled && node instanceof sqs.Queue) {
            this.monitoringFacade.monitorSqsQueue({
                queue: node,
                ...props,
            });
        }
    }
    monitorStepFunctions(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.stepFunctions);
        if (isEnabled && node instanceof stepfunctions.StateMachine) {
            this.monitoringFacade.monitorStepFunction({
                stateMachine: node,
                ...props,
            });
        }
    }
    monitorSyntheticsCanaries(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.syntheticsCanaries);
        if (isEnabled && node instanceof synthetics.Canary) {
            this.monitoringFacade.monitorSyntheticsCanary({
                canary: node,
                ...props,
            });
        }
    }
    monitorWebApplicationFirewallV2Acls(node) {
        const [isEnabled, props] = this.getMonitoringDetails(this.props.webApplicationFirewallAclV2);
        if (isEnabled && node instanceof wafv2.CfnWebACL) {
            this.monitoringFacade.monitorWebApplicationFirewallAclV2({
                acl: node,
                ...props,
            });
        }
    }
}
exports.MonitoringAspect = MonitoringAspect;
_a = JSII_RTTI_SYMBOL_1;
MonitoringAspect[_a] = { fqn: "cdk-monitoring-constructs.MonitoringAspect", version: "1.6.2" };
__exportStar(require("./aspect-types"), exports);
//# sourceMappingURL=data:application/json;base64,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