"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitoringFacade = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const common_1 = require("../common");
const dashboard_1 = require("../dashboard");
const monitoring_1 = require("../monitoring");
const MonitoringAspect_1 = require("./MonitoringAspect");
/**
 * Main entry point to create your monitoring.
 */
class MonitoringFacade extends common_1.MonitoringScope {
    constructor(scope, id, props) {
        super(scope, id);
        this.metricFactoryDefaults = props.metricFactoryDefaults;
        this.alarmFactoryDefaults = props.alarmFactoryDefaults;
        this.dashboardFactory = props.dashboardFactory;
        this.createdSegments = [];
    }
    // FACTORIES
    // =========
    createAlarmFactory(alarmNamePrefix) {
        return new common_1.AlarmFactory(this, {
            globalAlarmDefaults: this.alarmFactoryDefaults,
            globalMetricDefaults: this.metricFactoryDefaults,
            localAlarmNamePrefix: alarmNamePrefix,
        });
    }
    createAwsConsoleUrlFactory() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const awsAccountId = stack.account;
        const awsAccountRegion = stack.region;
        return new common_1.AwsConsoleUrlFactory({ awsAccountRegion, awsAccountId });
    }
    createMetricFactory() {
        return new common_1.MetricFactory({ globalDefaults: this.metricFactoryDefaults });
    }
    createWidgetFactory() {
        return new dashboard_1.DefaultWidgetFactory();
    }
    // GENERIC
    // =======
    createdDashboard() {
        var _b;
        return (_b = this.dashboardFactory) === null || _b === void 0 ? void 0 : _b.createdDashboard();
    }
    createdSummaryDashboard() {
        var _b;
        return (_b = this.dashboardFactory) === null || _b === void 0 ? void 0 : _b.createdSummaryDashboard();
    }
    createdAlarmDashboard() {
        var _b;
        return (_b = this.dashboardFactory) === null || _b === void 0 ? void 0 : _b.createdAlarmDashboard();
    }
    /**
     * Returns the created alarms across all the monitorings added up until now.
     */
    createdAlarms() {
        const alarms = [];
        this.createdSegments.forEach((monitoring) => {
            if (monitoring instanceof common_1.Monitoring) {
                alarms.push(...monitoring.createdAlarms());
            }
        });
        return alarms;
    }
    /**
     * Returns a subset of created alarms that are marked by a specific custom tag.
     * @param customTag tag to filter alarms by
     */
    createdAlarmsWithTag(customTag) {
        return this.createdAlarms().filter((alarm) => { var _b; return (_b = alarm.customTags) === null || _b === void 0 ? void 0 : _b.includes(customTag); });
    }
    /**
     * Returns a subset of created alarms that are marked by a specific disambiguator.
     * @param disambiguator disambiguator to filter alarms by
     */
    createdAlarmsWithDisambiguator(disambiguator) {
        return this.createdAlarms().filter((alarm) => alarm.disambiguator === disambiguator);
    }
    /**
     * Finds a subset of created alarms that are marked by a specific custom tag and creates a composite alarm.
     * This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
     * NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.
     *
     * @param customTag tag to filter alarms by
     * @param props customization options
     */
    createCompositeAlarmUsingTag(customTag, props) {
        var _b;
        const alarms = this.createdAlarmsWithTag(customTag);
        if (alarms.length > 0) {
            const disambiguator = (_b = props === null || props === void 0 ? void 0 : props.disambiguator) !== null && _b !== void 0 ? _b : customTag;
            const alarmFactory = this.createAlarmFactory("Composite");
            return alarmFactory.addCompositeAlarm(alarms, {
                ...(props !== null && props !== void 0 ? props : {}),
                disambiguator,
            });
        }
        return undefined;
    }
    /**
     * Finds a subset of created alarms that are marked by a specific disambiguator and creates a composite alarm.
     * This composite alarm is created with an 'OR' condition, so it triggers with any child alarm.
     * NOTE: This composite alarm is not added among other alarms, so it is not returned by createdAlarms() calls.
     *
     * @param alarmDisambiguator disambiguator to filter alarms by
     * @param props customization options
     */
    createCompositeAlarmUsingDisambiguator(alarmDisambiguator, props) {
        var _b;
        const alarms = this.createdAlarmsWithDisambiguator(alarmDisambiguator);
        if (alarms.length > 0) {
            const disambiguator = (_b = props === null || props === void 0 ? void 0 : props.disambiguator) !== null && _b !== void 0 ? _b : alarmDisambiguator;
            const alarmFactory = this.createAlarmFactory("Composite");
            return alarmFactory.addCompositeAlarm(alarms, {
                ...(props !== null && props !== void 0 ? props : {}),
                disambiguator,
            });
        }
        return undefined;
    }
    /**
     * Returns the created monitorings added up until now.
     */
    createdMonitorings() {
        return this.createdSegments
            .filter((s) => s instanceof common_1.Monitoring)
            .map((s) => s);
    }
    addSegment(segment, overrideProps) {
        var _b;
        (_b = this.dashboardFactory) === null || _b === void 0 ? void 0 : _b.addSegment({ segment, overrideProps });
        this.createdSegments.push(segment);
        return this;
    }
    addLargeHeader(text, addToSummary, addToAlarm) {
        this.addWidget(new dashboard_1.HeaderWidget(text, dashboard_1.HeaderLevel.LARGE), addToSummary !== null && addToSummary !== void 0 ? addToSummary : false, addToAlarm !== null && addToAlarm !== void 0 ? addToAlarm : false);
        return this;
    }
    addMediumHeader(text, addToSummary, addToAlarm) {
        this.addWidget(new dashboard_1.HeaderWidget(text, dashboard_1.HeaderLevel.MEDIUM), addToSummary !== null && addToSummary !== void 0 ? addToSummary : false, addToAlarm !== null && addToAlarm !== void 0 ? addToAlarm : false);
        return this;
    }
    addSmallHeader(text, addToSummary, addToAlarm) {
        this.addWidget(new dashboard_1.HeaderWidget(text, dashboard_1.HeaderLevel.SMALL), addToSummary !== null && addToSummary !== void 0 ? addToSummary : false, addToAlarm !== null && addToAlarm !== void 0 ? addToAlarm : false);
        return this;
    }
    addWidget(widget, addToSummary, addToAlarm) {
        this.addSegment(new dashboard_1.SingleWidgetDashboardSegment(widget, addToSummary, addToAlarm));
        return this;
    }
    // MONITORING
    // ==========
    monitorApiGateway(props) {
        const segment = new monitoring_1.ApiGatewayMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorApiGatewayV2HttpApi(props) {
        const segment = new monitoring_1.ApiGatewayV2HttpApiMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorAppSyncApi(props) {
        const segment = new monitoring_1.AppSyncMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorCertificate(props) {
        const segment = new monitoring_1.CertificateManagerMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorCloudFrontDistribution(props) {
        const segment = new monitoring_1.CloudFrontDistributionMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorCodeBuildProject(props) {
        const segment = new monitoring_1.CodeBuildProjectMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorDynamoTable(props) {
        const segment = new monitoring_1.DynamoTableMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorDynamoTableGlobalSecondaryIndex(props) {
        const segment = new monitoring_1.DynamoTableGlobalSecondaryIndexMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorEC2Instances(props) {
        const segment = new monitoring_1.EC2Monitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorElasticsearchCluster(props) {
        const segment = new monitoring_1.OpenSearchClusterMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorOpenSearchCluster(props) {
        const segment = new monitoring_1.OpenSearchClusterMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorElastiCacheCluster(props) {
        const segment = new monitoring_1.ElastiCacheClusterMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorGlueJob(props) {
        const segment = new monitoring_1.GlueJobMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorFargateService(props) {
        const segment = new monitoring_1.FargateServiceMonitoring(this, {
            ...props,
            fargateService: props.fargateService.service,
            loadBalancer: props.fargateService.loadBalancer,
            targetGroup: props.fargateService.targetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorSimpleFargateService(props) {
        const segment = new monitoring_1.FargateServiceMonitoring(this, {
            ...props,
            fargateService: props.fargateService,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorFargateNetworkLoadBalancer(props) {
        const segment = new monitoring_1.FargateServiceMonitoring(this, {
            ...props,
            fargateService: props.fargateService,
            loadBalancer: props.networkLoadBalancer,
            targetGroup: props.networkTargetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorFargateApplicationLoadBalancer(props) {
        const segment = new monitoring_1.FargateServiceMonitoring(this, {
            ...props,
            fargateService: props.fargateService,
            loadBalancer: props.applicationLoadBalancer,
            targetGroup: props.applicationTargetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorEc2Service(props) {
        const segment = new monitoring_1.Ec2ServiceMonitoring(this, {
            ...props,
            ec2Service: props.ec2Service.service,
            loadBalancer: props.ec2Service.loadBalancer,
            targetGroup: props.ec2Service.targetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorSimpleEc2Service(props) {
        const segment = new monitoring_1.Ec2ServiceMonitoring(this, {
            ...props,
            ec2Service: props.ec2Service,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorEc2NetworkLoadBalancer(props) {
        const segment = new monitoring_1.Ec2ServiceMonitoring(this, {
            ...props,
            ec2Service: props.ec2Service,
            loadBalancer: props.networkLoadBalancer,
            targetGroup: props.networkTargetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorEc2ApplicationLoadBalancer(props) {
        const segment = new monitoring_1.Ec2ServiceMonitoring(this, {
            ...props,
            ec2Service: props.ec2Service,
            loadBalancer: props.applicationLoadBalancer,
            targetGroup: props.applicationTargetGroup,
        });
        this.addSegment(segment, props);
        return this;
    }
    monitorQueueProcessingFargateService(props) {
        monitoring_1.getQueueProcessingFargateServiceMonitoring(this, props).forEach((segment) => this.addSegment(segment));
        return this;
    }
    monitorQueueProcessingEc2Service(props) {
        monitoring_1.getQueueProcessingEc2ServiceMonitoring(this, props).forEach((segment) => this.addSegment(segment));
        return this;
    }
    monitorAutoScalingGroup(props) {
        const segment = new monitoring_1.AutoScalingGroupMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorKinesisFirehose(props) {
        const segment = new monitoring_1.KinesisFirehoseMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorKinesisDataStream(props) {
        const segment = new monitoring_1.KinesisDataStreamMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorKinesisDataAnalytics(props) {
        const segment = new monitoring_1.KinesisDataAnalyticsMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorLambdaFunction(props) {
        const segment = new monitoring_1.LambdaFunctionMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorNetworkLoadBalancer(props) {
        const segment = new monitoring_1.NetworkLoadBalancerMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorRdsCluster(props) {
        const segment = new monitoring_1.RdsClusterMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorRedshiftCluster(props) {
        const segment = new monitoring_1.RedshiftClusterMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorSecretsManagerSecret(props) {
        const segment = new monitoring_1.SecretsManagerSecretMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorSnsTopic(props) {
        const segment = new monitoring_1.SnsTopicMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorSqsQueue(props) {
        const segment = new monitoring_1.SqsQueueMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorSqsQueueWithDlq(props) {
        const segment = new monitoring_1.SqsQueueMonitoringWithDlq(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorStepFunction(props) {
        const segment = new monitoring_1.StepFunctionMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorStepFunctionActivity(props) {
        const segment = new monitoring_1.StepFunctionActivityMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorStepFunctionLambdaIntegration(props) {
        const segment = new monitoring_1.StepFunctionLambdaIntegrationMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorStepFunctionServiceIntegration(props) {
        const segment = new monitoring_1.StepFunctionServiceIntegrationMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorS3Bucket(props) {
        const segment = new monitoring_1.S3BucketMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorLog(props) {
        const segment = new monitoring_1.LogMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorSyntheticsCanary(props) {
        const segment = new monitoring_1.SyntheticsCanaryMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorWebApplicationFirewallAclV2(props) {
        const segment = new monitoring_1.WafV2Monitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    monitorBilling(props) {
        const segment = new monitoring_1.BillingMonitoring(this, props !== null && props !== void 0 ? props : {});
        this.addSegment(segment, props);
        return this;
    }
    monitorCustom(props) {
        const segment = new monitoring_1.CustomMonitoring(this, props);
        this.addSegment(segment, props);
        return this;
    }
    /**
     * Monitor all the resources in the given scope.
     * @param scope
     * @param aspectProps
     * @experimental
     */
    monitorScope(scope, aspectProps) {
        const aspect = new MonitoringAspect_1.MonitoringAspect(this, aspectProps);
        aws_cdk_lib_1.Aspects.of(scope).add(aspect);
    }
}
exports.MonitoringFacade = MonitoringFacade;
_a = JSII_RTTI_SYMBOL_1;
MonitoringFacade[_a] = { fqn: "cdk-monitoring-constructs.MonitoringFacade", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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