"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateManagerMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/CertificateManager";
class CertificateManagerMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            CertificateArn: props.certificate.certificateArn,
        };
    }
    metricDaysToExpiry() {
        return this.metricFactory.createMetric("DaysToExpiry", common_1.MetricStatistic.MIN, "Days to expiry", this.dimensionsMap, undefined, Namespace);
    }
}
exports.CertificateManagerMetricFactory = CertificateManagerMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
CertificateManagerMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.CertificateManagerMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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