import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, DaysToExpiryThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { CertificateManagerMetricFactoryProps } from "./CertificateManagerMetricFactory";
export interface CertificateManagerMonitoringOptions extends BaseMonitoringProps {
    readonly addDaysToExpiryAlarm?: Record<string, DaysToExpiryThreshold>;
}
export interface CertificateManagerMonitoringProps extends CertificateManagerMonitoringOptions, CertificateManagerMetricFactoryProps {
}
export declare class CertificateManagerMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly daysToExpiryAnnotations: HorizontalAnnotation[];
    protected readonly daysToExpiryMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: CertificateManagerMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createTitleWidget(): MonitoringHeaderWidget;
    protected createDaysToExpiryWidget(width: number, height: number): GraphWidget;
}
