"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateManagerMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const CertificateManagerMetricFactory_1 = require("./CertificateManagerMetricFactory");
class CertificateManagerMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        var _b;
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({ ...props });
        this.title = namingStrategy.resolveHumanReadableName();
        const metricFactory = new CertificateManagerMetricFactory_1.CertificateManagerMetricFactory(scope.createMetricFactory(), props);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        const ageAlarmFactory = new common_1.AgeAlarmFactory(alarmFactory);
        this.daysToExpiryAnnotations = [];
        this.daysToExpiryMetric = metricFactory.metricDaysToExpiry();
        for (const disambiguator in props.addDaysToExpiryAlarm) {
            const alarmProps = props.addDaysToExpiryAlarm[disambiguator];
            const createdAlarm = ageAlarmFactory.addDaysToExpiryAlarm(this.daysToExpiryMetric, alarmProps, disambiguator);
            this.daysToExpiryAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        (_b = props.useCreatedAlarms) === null || _b === void 0 ? void 0 : _b.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createDaysToExpiryWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Certificate",
            title: this.title,
        });
    }
    createDaysToExpiryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Expiration",
            left: [this.daysToExpiryMetric],
            leftAnnotations: this.daysToExpiryAnnotations,
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.CertificateManagerMonitoring = CertificateManagerMonitoring;
_a = JSII_RTTI_SYMBOL_1;
CertificateManagerMonitoring[_a] = { fqn: "cdk-monitoring-constructs.CertificateManagerMonitoring", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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