"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const ApiGatewayNamespace = "AWS/ApiGateway";
class ApiGatewayMetricFactory {
    constructor(metricFactory, props) {
        var _b, _c, _d;
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = (_b = props.fillTpsWithZeroes) !== null && _b !== void 0 ? _b : true;
        this.rateComputationMethod = (_c = props.rateComputationMethod) !== null && _c !== void 0 ? _c : common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ApiName: props.api.restApiName,
            Stage: (_d = props.apiStage) !== null && _d !== void 0 ? _d : "prod",
            ...(props.apiMethod && { Method: props.apiMethod }),
            ...(props.apiResource && { Resource: props.apiResource }),
        };
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationCount() {
        return this.metricFactory.createMetric("Count", common_1.MetricStatistic.SUM, "Count", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4XXErrorCount() {
        return this.metricFactory.createMetric("4XXError", common_1.MetricStatistic.SUM, "4XX Error", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4XXErrorRate() {
        const metric = this.metric4XXErrorCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5XXFaultCount() {
        return this.metricFactory.createMetric("5XXError", common_1.MetricStatistic.SUM, "5XX Fault", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric5XXFaultRate() {
        const metric = this.metric5XXFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP99InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P99);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP90InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP50InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P50);
    }
    metricLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("Latency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
}
exports.ApiGatewayMetricFactory = ApiGatewayMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ApiGatewayMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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