"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayV2HttpApiMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const ApiGatewayNamespace = "AWS/ApiGateway";
class ApiGatewayV2HttpApiMetricFactory {
    constructor(metricFactory, props) {
        var _b, _c, _d;
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = (_b = props.fillTpsWithZeroes) !== null && _b !== void 0 ? _b : true;
        this.rateComputationMethod = (_c = props.rateComputationMethod) !== null && _c !== void 0 ? _c : common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ApiId: props.api.httpApiId,
            Stage: (_d = props.apiStage) !== null && _d !== void 0 ? _d : "$default",
            ...(props.apiMethod && { Method: props.apiMethod }),
            ...(props.apiResource && { Resource: props.apiResource }),
        };
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests");
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests");
    }
    metricInvocationCount() {
        return this.metricFactory.createMetric("Count", common_1.MetricStatistic.SUM, "Invocations", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4xxCount() {
        return this.metricFactory.createMetric("4xx", common_1.MetricStatistic.SUM, "4xx", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4xxRate() {
        const metric = this.metric4xxCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5xxCount() {
        return this.metricFactory.createMetric("5xx", common_1.MetricStatistic.SUM, "5xx", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric5xxRate() {
        const metric = this.metric5xxCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP50InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P50);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP90InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP99InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P99);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP50InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P50);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP90InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP99InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P99);
    }
    metricIntegrationLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("IntegrationLatency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metricLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("Latency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
}
exports.ApiGatewayV2HttpApiMetricFactory = ApiGatewayV2HttpApiMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayV2HttpApiMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactory", version: "1.6.2" };
//# sourceMappingURL=data:application/json;base64,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