import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { AlarmFactory, BaseMonitoringProps, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, HighTpsThreshold, LatencyAlarmFactory, LatencyThreshold, LowTpsThreshold, MetricWithAlarmSupport, Monitoring, MonitoringScope, TpsAlarmFactory } from "../../common";
import { MonitoringHeaderWidget, MonitoringNamingStrategy } from "../../dashboard";
import { AppSyncMetricFactory, AppSyncMetricFactoryProps } from "./AppSyncMetricFactory";
export interface AppSyncMonitoringOptions extends BaseMonitoringProps {
    readonly addLatencyP50Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP90Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP99Alarm?: Record<string, LatencyThreshold>;
    readonly add4XXErrorCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly add4XXErrorRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly add5XXFaultCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly add5XXFaultRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addLowTpsAlarm?: Record<string, LowTpsThreshold>;
    readonly addHighTpsAlarm?: Record<string, HighTpsThreshold>;
}
export interface AppSyncMonitoringProps extends AppSyncMonitoringOptions, AppSyncMetricFactoryProps {
}
export declare class AppSyncMonitoring extends Monitoring {
    protected readonly title: string;
    protected readonly namingStrategy: MonitoringNamingStrategy;
    protected readonly metricFactory: AppSyncMetricFactory;
    protected readonly alarmFactory: AlarmFactory;
    protected readonly errorAlarmFactory: ErrorAlarmFactory;
    protected readonly latencyAlarmFactory: LatencyAlarmFactory;
    protected readonly tpsAlarmFactory: TpsAlarmFactory;
    protected readonly tpsAnnotations: HorizontalAnnotation[];
    protected readonly latencyAnnotations: HorizontalAnnotation[];
    protected readonly errorCountAnnotations: HorizontalAnnotation[];
    protected readonly errorRateAnnotations: HorizontalAnnotation[];
    protected readonly tpsMetric: MetricWithAlarmSupport;
    protected readonly p50LatencyMetric: MetricWithAlarmSupport;
    protected readonly p90LatencyMetric: MetricWithAlarmSupport;
    protected readonly p99LatencyMetric: MetricWithAlarmSupport;
    protected readonly fault5xxCountMetric: MetricWithAlarmSupport;
    protected readonly fault5xxRateMetric: MetricWithAlarmSupport;
    protected readonly error4xxCountMetric: MetricWithAlarmSupport;
    protected readonly error4xxRateMetric: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: AppSyncMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    protected createtTitleWidget(): MonitoringHeaderWidget;
    protected createTpsWidget(width: number, height: number): GraphWidget;
    protected createLatencyWidget(width: number, height: number): GraphWidget;
    protected createErrorCountWidget(width: number, height: number): GraphWidget;
    protected createErrorRateWidget(width: number, height: number): GraphWidget;
}
